/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.support.DynamicValuesPropertySource;
import org.springframework.util.Assert;

final class DefaultDynamicPropertyRegistry
implements DynamicPropertyRegistry {
    final Map<String, Supplier<Object>> valueSuppliers = Collections.synchronizedMap(new LinkedHashMap());
    private final ConfigurableEnvironment environment;
    private final boolean lazilyRegisterPropertySource;
    private final Lock propertySourcesLock = new ReentrantLock();

    DefaultDynamicPropertyRegistry(ConfigurableEnvironment environment, boolean lazilyRegisterPropertySource) {
        this.environment = environment;
        this.lazilyRegisterPropertySource = lazilyRegisterPropertySource;
    }

    @Override
    public void add(String name, Supplier<Object> valueSupplier) {
        Assert.hasText((String)name, (String)"'name' must not be null or blank");
        Assert.notNull(valueSupplier, (String)"'valueSupplier' must not be null");
        if (this.lazilyRegisterPropertySource) {
            this.ensurePropertySourceIsRegistered();
        }
        this.valueSuppliers.put(name, valueSupplier);
    }

    private void ensurePropertySourceIsRegistered() {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        this.propertySourcesLock.lock();
        try {
            PropertySource ps = propertySources.get("Dynamic Test Properties");
            if (ps == null) {
                propertySources.addFirst((PropertySource)new DynamicValuesPropertySource(this.valueSuppliers));
            }
        }
        finally {
            this.propertySourcesLock.unlock();
        }
    }
}

