/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.mockito.AdditionalAnswers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.listeners.VerificationStartedEvent;
import org.mockito.listeners.VerificationStartedListener;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.bean.override.mockito.MockitoOverrideMetadata;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBean;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class MockitoSpyBeanOverrideMetadata
extends MockitoOverrideMetadata {
    MockitoSpyBeanOverrideMetadata(Field field, ResolvableType typeToSpy, MockitoSpyBean spyAnnotation) {
        this(field, typeToSpy, StringUtils.hasText((String)spyAnnotation.name()) ? spyAnnotation.name() : null, spyAnnotation.reset(), spyAnnotation.proxyTargetAware());
    }

    MockitoSpyBeanOverrideMetadata(Field field, ResolvableType typeToSpy, @Nullable String beanName, MockReset reset, boolean proxyTargetAware) {
        super(field, typeToSpy, beanName, BeanOverrideStrategy.WRAP_BEAN, reset, proxyTargetAware);
        Assert.notNull((Object)typeToSpy, (String)"typeToSpy must not be null");
    }

    @Override
    protected Object createOverride(String beanName, @Nullable BeanDefinition existingBeanDefinition, @Nullable Object existingBeanInstance) {
        Assert.notNull((Object)existingBeanInstance, () -> "MockitoSpyBean requires an existing bean instance for bean " + beanName);
        return this.createSpy(beanName, existingBeanInstance);
    }

    <T> T createSpy(String name, Object instance) {
        Class<?> toSpy;
        Assert.notNull((Object)instance, (String)"Instance must not be null");
        Class resolvedTypeToOverride = this.getBeanType().resolve();
        Assert.notNull((Object)resolvedTypeToOverride, (String)"Failed to resolve type to override");
        Assert.isInstanceOf((Class)resolvedTypeToOverride, (Object)instance);
        if (Mockito.mockingDetails((Object)instance).isSpy()) {
            return (T)instance;
        }
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength((String)name)) {
            settings.name(name);
        }
        if (this.isProxyTargetAware()) {
            settings.verificationStartedListeners(new VerificationStartedListener[]{new SpringAopBypassingVerificationStartedListener()});
        }
        if (Proxy.isProxyClass(instance.getClass())) {
            settings.defaultAnswer(AdditionalAnswers.delegatesTo((Object)instance));
            toSpy = this.getBeanType().toClass();
        } else {
            settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
            settings.spiedInstance(instance);
            toSpy = instance.getClass();
        }
        return (T)Mockito.mock(toSpy, (MockSettings)settings);
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("beanName", (Object)this.getBeanName()).append("beanType", (Object)this.getBeanType()).append("reset", (Object)this.getReset()).toString();
    }

    private static final class SpringAopBypassingVerificationStartedListener
    implements VerificationStartedListener {
        private SpringAopBypassingVerificationStartedListener() {
        }

        public void onVerificationStarted(VerificationStartedEvent event) {
            event.setMock(AopTestUtils.getUltimateTargetObject(event.getMock()));
        }
    }
}

