/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import java.lang.reflect.Field;
import java.util.Objects;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.OverrideMetadata;
import org.springframework.test.context.bean.override.mockito.MockReset;
import org.springframework.test.context.bean.override.mockito.MockitoBeans;
import org.springframework.util.ObjectUtils;

abstract class MockitoOverrideMetadata
extends OverrideMetadata {
    private final MockReset reset;
    private final boolean proxyTargetAware;

    protected MockitoOverrideMetadata(Field field, ResolvableType beanType, @Nullable String beanName, BeanOverrideStrategy strategy, @Nullable MockReset reset, boolean proxyTargetAware) {
        super(field, beanType, beanName, strategy);
        this.reset = reset != null ? reset : MockReset.AFTER;
        this.proxyTargetAware = proxyTargetAware;
    }

    MockReset getReset() {
        return this.reset;
    }

    boolean isProxyTargetAware() {
        return this.proxyTargetAware;
    }

    @Override
    protected void track(Object mock, SingletonBeanRegistry trackingBeanRegistry) {
        MockitoBeans tracker = null;
        try {
            tracker = (MockitoBeans)trackingBeanRegistry.getSingleton(MockitoBeans.class.getName());
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (tracker == null) {
            tracker = new MockitoBeans();
            trackingBeanRegistry.registerSingleton(MockitoBeans.class.getName(), (Object)tracker);
        }
        tracker.add(mock);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        MockitoOverrideMetadata that = (MockitoOverrideMetadata)other;
        boolean result = super.equals(that);
        result = result && ObjectUtils.nullSafeEquals((Object)((Object)this.reset), (Object)((Object)that.reset));
        result = result && ObjectUtils.nullSafeEquals((Object)this.proxyTargetAware, (Object)that.proxyTargetAware);
        return result;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.reset, this.proxyTargetAware}) + super.hashCode();
    }
}

