/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.convention;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.test.context.bean.override.OverrideMetadata;
import org.springframework.util.ReflectionUtils;

final class TestBeanOverrideMetadata
extends OverrideMetadata {
    private final Method overrideMethod;

    TestBeanOverrideMetadata(Field field, ResolvableType beanType, @Nullable String beanName, Method overrideMethod) {
        super(field, beanType, beanName, BeanOverrideStrategy.REPLACE_DEFINITION);
        this.overrideMethod = overrideMethod;
    }

    @Override
    protected Object createOverride(String beanName, @Nullable BeanDefinition existingBeanDefinition, @Nullable Object existingBeanInstance) {
        try {
            ReflectionUtils.makeAccessible((Method)this.overrideMethod);
            return this.overrideMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalStateException("Failed to invoke bean overriding method " + this.overrideMethod.getName() + "; a static method with no formal parameters is expected", ex);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TestBeanOverrideMetadata that = (TestBeanOverrideMetadata)other;
        return Objects.equals(this.overrideMethod, that.overrideMethod);
    }

    @Override
    public int hashCode() {
        return this.overrideMethod.hashCode() * 29 + super.hashCode();
    }
}

