/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.bean.override.BeanOverride;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class OverrideMetadata {
    private final Field field;
    private final ResolvableType beanType;
    @Nullable
    private final String beanName;
    private final BeanOverrideStrategy strategy;

    protected OverrideMetadata(Field field, ResolvableType beanType, @Nullable String beanName, BeanOverrideStrategy strategy) {
        this.field = field;
        this.beanType = beanType;
        this.beanName = beanName;
        this.strategy = strategy;
    }

    public static List<OverrideMetadata> forTestClass(Class<?> testClass) {
        LinkedList<OverrideMetadata> metadata = new LinkedList<OverrideMetadata>();
        ReflectionUtils.doWithFields(testClass, field -> OverrideMetadata.parseField(field, testClass, metadata));
        return metadata;
    }

    private static void parseField(Field field, Class<?> testClass, List<OverrideMetadata> metadataList) {
        AtomicBoolean overrideAnnotationFound = new AtomicBoolean();
        MergedAnnotations.from((AnnotatedElement)field, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT).stream(BeanOverride.class).forEach(mergedAnnotation -> {
            MergedAnnotation metaSource = mergedAnnotation.getMetaSource();
            Assert.state((metaSource != null ? 1 : 0) != 0, (String)"@BeanOverride annotation must be meta-present");
            BeanOverride beanOverride = (BeanOverride)mergedAnnotation.synthesize();
            BeanOverrideProcessor processor = (BeanOverrideProcessor)BeanUtils.instantiateClass(beanOverride.value());
            Annotation composedAnnotation = metaSource.synthesize();
            Assert.state((boolean)overrideAnnotationFound.compareAndSet(false, true), () -> "Multiple @BeanOverride annotations found on field: " + field);
            OverrideMetadata metadata = processor.createMetadata(composedAnnotation, testClass, field);
            metadataList.add(metadata);
        });
    }

    public final Field getField() {
        return this.field;
    }

    public final ResolvableType getBeanType() {
        return this.beanType;
    }

    @Nullable
    public String getBeanName() {
        return this.beanName;
    }

    public final BeanOverrideStrategy getStrategy() {
        return this.strategy;
    }

    protected abstract Object createOverride(String var1, @Nullable BeanDefinition var2, @Nullable Object var3);

    protected void track(Object override, SingletonBeanRegistry trackingBeanRegistry) {
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        OverrideMetadata that = (OverrideMetadata)other;
        if (!(Objects.equals(this.beanType.getType(), that.beanType.getType()) && Objects.equals(this.beanName, that.beanName) && Objects.equals((Object)this.strategy, (Object)that.strategy))) {
            return false;
        }
        if (this.beanName != null) {
            return true;
        }
        return Objects.equals(this.field.getName(), that.field.getName()) && Arrays.equals(this.field.getAnnotations(), that.field.getAnnotations());
    }

    public int hashCode() {
        int hash = Objects.hash(new Object[]{this.getClass(), this.beanType.getType(), this.beanName, this.strategy});
        return this.beanName != null ? hash : hash + Objects.hash(this.field.getName(), Arrays.hashCode(this.field.getAnnotations()));
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("field", (Object)this.field).append("beanType", (Object)this.beanType).append("beanName", (Object)this.beanName).append("strategy", (Object)this.strategy).toString();
    }
}

