/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;
import org.springframework.transaction.interceptor.DelegatingTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class TestContextTransactionUtils {
    public static final String DEFAULT_DATA_SOURCE_NAME = "dataSource";
    public static final String DEFAULT_TRANSACTION_MANAGER_NAME = "transactionManager";
    private static final Log logger = LogFactory.getLog(TestContextTransactionUtils.class);

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static DataSource retrieveDataSource(TestContext testContext, @Nullable String name) {
        AutowireCapableBeanFactory bf;
        block8: {
            Assert.notNull((Object)testContext, (String)"TestContext must not be null");
            bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
            try {
                if (StringUtils.hasText((String)name)) {
                    return (DataSource)bf.getBean(name, DataSource.class);
                }
            }
            catch (BeansException ex) {
                logger.error((Object)String.format("Failed to retrieve DataSource named '%s' for test context %s", name, testContext), (Throwable)ex);
                throw ex;
            }
            if (!(bf instanceof ListableBeanFactory)) return (DataSource)bf.getBean(DEFAULT_DATA_SOURCE_NAME, DataSource.class);
            ListableBeanFactory lbf = (ListableBeanFactory)bf;
            Map dataSources = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)lbf, DataSource.class);
            if (dataSources.size() != 1) break block8;
            return (DataSource)dataSources.values().iterator().next();
            {
                catch (BeansException ex) {
                    TestContextTransactionUtils.logBeansException(testContext, ex, DataSource.class);
                    return null;
                }
            }
        }
        try {
            return (DataSource)bf.getBean(DataSource.class);
        }
        catch (BeansException ex) {
            TestContextTransactionUtils.logBeansException(testContext, ex, PlatformTransactionManager.class);
            return (DataSource)bf.getBean(DEFAULT_DATA_SOURCE_NAME, DataSource.class);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static PlatformTransactionManager retrieveTransactionManager(TestContext testContext, @Nullable String name) {
        AutowireCapableBeanFactory bf;
        block9: {
            Assert.notNull((Object)testContext, (String)"TestContext must not be null");
            bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
            try {
                if (StringUtils.hasText((String)name)) {
                    return (PlatformTransactionManager)bf.getBean(name, PlatformTransactionManager.class);
                }
            }
            catch (BeansException ex) {
                logger.error((Object)String.format("Failed to retrieve transaction manager named '%s' for test context %s", name, testContext), (Throwable)ex);
                throw ex;
            }
            if (!(bf instanceof ListableBeanFactory)) return (PlatformTransactionManager)bf.getBean(DEFAULT_TRANSACTION_MANAGER_NAME, PlatformTransactionManager.class);
            ListableBeanFactory lbf = (ListableBeanFactory)bf;
            Map configurers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)lbf, TransactionManagementConfigurer.class);
            Assert.state((configurers.size() <= 1 ? 1 : 0) != 0, (String)"Only one TransactionManagementConfigurer may exist in the ApplicationContext");
            if (configurers.size() == 1) {
                TransactionManager tm = ((TransactionManagementConfigurer)configurers.values().iterator().next()).annotationDrivenTransactionManager();
                Assert.state((boolean)(tm instanceof PlatformTransactionManager), () -> "Transaction manager specified via TransactionManagementConfigurer is not a PlatformTransactionManager: " + tm);
                return (PlatformTransactionManager)tm;
            }
            Map txMgrs = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)lbf, PlatformTransactionManager.class);
            if (txMgrs.size() != 1) break block9;
            return (PlatformTransactionManager)txMgrs.values().iterator().next();
            {
                catch (BeansException ex) {
                    TestContextTransactionUtils.logBeansException(testContext, ex, PlatformTransactionManager.class);
                    return null;
                }
            }
        }
        try {
            return (PlatformTransactionManager)bf.getBean(PlatformTransactionManager.class);
        }
        catch (BeansException ex) {
            TestContextTransactionUtils.logBeansException(testContext, ex, PlatformTransactionManager.class);
            return (PlatformTransactionManager)bf.getBean(DEFAULT_TRANSACTION_MANAGER_NAME, PlatformTransactionManager.class);
        }
    }

    private static void logBeansException(TestContext testContext, BeansException ex, Class<?> beanType) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Caught exception while retrieving %s for test context %s".formatted(beanType.getSimpleName(), testContext), (Throwable)ex);
        }
    }

    public static TransactionAttribute createDelegatingTransactionAttribute(TestContext testContext, TransactionAttribute targetAttribute) {
        return TestContextTransactionUtils.createDelegatingTransactionAttribute(testContext, targetAttribute, true);
    }

    public static TransactionAttribute createDelegatingTransactionAttribute(TestContext testContext, TransactionAttribute targetAttribute, boolean includeMethodName) {
        Assert.notNull((Object)testContext, (String)"TestContext must not be null");
        Assert.notNull((Object)targetAttribute, (String)"Target TransactionAttribute must not be null");
        return new TestContextTransactionAttribute(targetAttribute, testContext, includeMethodName);
    }

    private static class TestContextTransactionAttribute
    extends DelegatingTransactionAttribute {
        private final String name;

        public TestContextTransactionAttribute(TransactionAttribute targetAttribute, TestContext testContext, boolean includeMethodName) {
            super(targetAttribute);
            Object name = testContext.getTestClass().getName();
            if (includeMethodName) {
                name = (String)name + "." + testContext.getTestMethod().getName();
            }
            this.name = name;
        }

        @Nullable
        public String getName() {
            return this.name;
        }
    }
}

