/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.ExceptionCollector;
import org.springframework.test.util.JsonExpectationsHelper;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.reactive.server.CookieAssertions;
import org.springframework.test.web.reactive.server.DefaultWebTestClientBuilder;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.FluxExchangeResult;
import org.springframework.test.web.reactive.server.HeaderAssertions;
import org.springframework.test.web.reactive.server.JsonPathAssertions;
import org.springframework.test.web.reactive.server.StatusAssertions;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.test.web.reactive.server.WiretapConnector;
import org.springframework.test.web.reactive.server.XpathAssertions;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;

class DefaultWebTestClient
implements WebTestClient {
    private final WiretapConnector wiretapConnector;
    private final ExchangeFunction exchangeFunction;
    private final UriBuilderFactory uriBuilderFactory;
    @Nullable
    private final HttpHeaders defaultHeaders;
    @Nullable
    private final MultiValueMap<String, String> defaultCookies;
    private final Consumer<EntityExchangeResult<?>> entityResultConsumer;
    private final Duration responseTimeout;
    private final DefaultWebTestClientBuilder builder;
    private final AtomicLong requestIndex = new AtomicLong();

    DefaultWebTestClient(ClientHttpConnector connector, Function<ClientHttpConnector, ExchangeFunction> exchangeFactory, UriBuilderFactory uriBuilderFactory, @Nullable HttpHeaders headers, @Nullable MultiValueMap<String, String> cookies, Consumer<EntityExchangeResult<?>> entityResultConsumer, @Nullable Duration responseTimeout, DefaultWebTestClientBuilder clientBuilder) {
        this.wiretapConnector = new WiretapConnector(connector);
        this.exchangeFunction = exchangeFactory.apply(this.wiretapConnector);
        this.uriBuilderFactory = uriBuilderFactory;
        this.defaultHeaders = headers;
        this.defaultCookies = cookies;
        this.entityResultConsumer = entityResultConsumer;
        this.responseTimeout = responseTimeout != null ? responseTimeout : Duration.ofSeconds(5L);
        this.builder = clientBuilder;
    }

    private Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    @Override
    public WebTestClient.RequestHeadersUriSpec<?> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public WebTestClient.RequestHeadersUriSpec<?> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public WebTestClient.RequestBodyUriSpec post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public WebTestClient.RequestBodyUriSpec put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public WebTestClient.RequestBodyUriSpec patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public WebTestClient.RequestHeadersUriSpec<?> delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public WebTestClient.RequestHeadersUriSpec<?> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public WebTestClient.RequestBodyUriSpec method(HttpMethod httpMethod) {
        return this.methodInternal(httpMethod);
    }

    private WebTestClient.RequestBodyUriSpec methodInternal(HttpMethod httpMethod) {
        return new DefaultRequestBodyUriSpec(httpMethod);
    }

    @Override
    public WebTestClient.Builder mutate() {
        return new DefaultWebTestClientBuilder(this.builder);
    }

    @Override
    public WebTestClient mutateWith(WebTestClientConfigurer configurer) {
        return this.mutate().apply(configurer).build();
    }

    private class DefaultRequestBodyUriSpec
    implements WebTestClient.RequestBodyUriSpec {
        private final HttpMethod httpMethod;
        @Nullable
        private URI uri;
        private final HttpHeaders headers;
        @Nullable
        private MultiValueMap<String, String> cookies;
        @Nullable
        private BodyInserter<?, ? super ClientHttpRequest> inserter;
        private final Map<String, Object> attributes = new LinkedHashMap<String, Object>(4);
        @Nullable
        private String uriTemplate;
        private final String requestId;

        DefaultRequestBodyUriSpec(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            this.requestId = String.valueOf(DefaultWebTestClient.this.requestIndex.incrementAndGet());
            this.headers = new HttpHeaders();
            this.headers.add("WebTestClient-Request-Id", this.requestId);
        }

        @Override
        public WebTestClient.RequestBodySpec uri(String uriTemplate, Object ... uriVariables) {
            this.uriTemplate = uriTemplate;
            return this.uri(DefaultWebTestClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public WebTestClient.RequestBodySpec uri(String uriTemplate, Map<String, ?> uriVariables) {
            this.uriTemplate = uriTemplate;
            return this.uri(DefaultWebTestClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public WebTestClient.RequestBodySpec uri(Function<UriBuilder, URI> uriFunction) {
            this.uriTemplate = null;
            return this.uri(uriFunction.apply(DefaultWebTestClient.this.uriBuilderFactory.builder()));
        }

        @Override
        public WebTestClient.RequestBodySpec uri(URI uri) {
            this.uri = uri;
            return this;
        }

        private HttpHeaders getHeaders() {
            return this.headers;
        }

        private MultiValueMap<String, String> getCookies() {
            if (this.cookies == null) {
                this.cookies = new LinkedMultiValueMap(3);
            }
            return this.cookies;
        }

        @Override
        public WebTestClient.RequestBodySpec header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.getHeaders().add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec headers(Consumer<HttpHeaders> headersConsumer) {
            headersConsumer.accept(this.getHeaders());
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec attribute(String name, Object value) {
            this.attributes.put(name, value);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            attributesConsumer.accept(this.attributes);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec accept(MediaType ... acceptableMediaTypes) {
            this.getHeaders().setAccept(Arrays.asList(acceptableMediaTypes));
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec acceptCharset(Charset ... acceptableCharsets) {
            this.getHeaders().setAcceptCharset(Arrays.asList(acceptableCharsets));
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec contentType(MediaType contentType) {
            this.getHeaders().setContentType(contentType);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec contentLength(long contentLength) {
            this.getHeaders().setContentLength(contentLength);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec cookie(String name, String value) {
            this.getCookies().add((Object)name, (Object)value);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
            cookiesConsumer.accept(this.getCookies());
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.getHeaders().setIfModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public WebTestClient.RequestBodySpec ifNoneMatch(String ... ifNoneMatches) {
            this.getHeaders().setIfNoneMatch(Arrays.asList(ifNoneMatches));
            return this;
        }

        @Override
        public WebTestClient.RequestHeadersSpec<?> bodyValue(Object body2) {
            this.inserter = BodyInserters.fromValue((Object)body2);
            return this;
        }

        public <T, P extends Publisher<T>> WebTestClient.RequestHeadersSpec<?> body(P publisher, ParameterizedTypeReference<T> elementTypeRef) {
            this.inserter = BodyInserters.fromPublisher(publisher, elementTypeRef);
            return this;
        }

        public <T, P extends Publisher<T>> WebTestClient.RequestHeadersSpec<?> body(P publisher, Class<T> elementClass) {
            this.inserter = BodyInserters.fromPublisher(publisher, elementClass);
            return this;
        }

        @Override
        public WebTestClient.RequestHeadersSpec<?> body(Object producer, Class<?> elementClass) {
            this.inserter = BodyInserters.fromProducer((Object)producer, elementClass);
            return this;
        }

        @Override
        public WebTestClient.RequestHeadersSpec<?> body(Object producer, ParameterizedTypeReference<?> elementTypeRef) {
            this.inserter = BodyInserters.fromProducer((Object)producer, elementTypeRef);
            return this;
        }

        @Override
        public WebTestClient.RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
            this.inserter = inserter;
            return this;
        }

        @Override
        @Deprecated
        public WebTestClient.RequestHeadersSpec<?> syncBody(Object body2) {
            return this.bodyValue(body2);
        }

        @Override
        public WebTestClient.ResponseSpec exchange() {
            ClientRequest request2 = this.inserter != null ? this.initRequestBuilder().body(this.inserter).build() : this.initRequestBuilder().build();
            ClientResponse response = (ClientResponse)DefaultWebTestClient.this.exchangeFunction.exchange(request2).block(DefaultWebTestClient.this.getResponseTimeout());
            Assert.state((response != null ? 1 : 0) != 0, (String)"No ClientResponse");
            ExchangeResult result = DefaultWebTestClient.this.wiretapConnector.getExchangeResult(this.requestId, this.uriTemplate, DefaultWebTestClient.this.getResponseTimeout());
            return new DefaultResponseSpec(result, response, DefaultWebTestClient.this.entityResultConsumer, DefaultWebTestClient.this.getResponseTimeout());
        }

        private ClientRequest.Builder initRequestBuilder() {
            return ClientRequest.create((HttpMethod)this.httpMethod, (URI)this.initUri()).headers(headersToUse -> {
                if (!CollectionUtils.isEmpty((Map)DefaultWebTestClient.this.defaultHeaders)) {
                    headersToUse.putAll((Map)DefaultWebTestClient.this.defaultHeaders);
                }
                if (!CollectionUtils.isEmpty((Map)this.headers)) {
                    headersToUse.putAll((Map)this.headers);
                }
            }).cookies(cookiesToUse -> {
                if (!CollectionUtils.isEmpty(DefaultWebTestClient.this.defaultCookies)) {
                    cookiesToUse.putAll(DefaultWebTestClient.this.defaultCookies);
                }
                if (!CollectionUtils.isEmpty(this.cookies)) {
                    cookiesToUse.putAll(this.cookies);
                }
            }).attributes(attributes -> attributes.putAll(this.attributes));
        }

        private URI initUri() {
            return this.uri != null ? this.uri : DefaultWebTestClient.this.uriBuilderFactory.expand("", new Object[0]);
        }
    }

    private static class DefaultBodyContentSpec
    implements WebTestClient.BodyContentSpec {
        private final EntityExchangeResult<byte[]> result;
        private final boolean isEmpty;

        DefaultBodyContentSpec(EntityExchangeResult<byte[]> result) {
            this.result = result;
            this.isEmpty = result.getResponseBody() == null || result.getResponseBody().length == 0;
        }

        @Override
        public EntityExchangeResult<Void> isEmpty() {
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertTrue("Expected empty body", this.isEmpty));
            return new EntityExchangeResult<Object>(this.result, null);
        }

        @Override
        public WebTestClient.BodyContentSpec json(String json, boolean strict) {
            this.result.assertWithDiagnostics(() -> {
                try {
                    new JsonExpectationsHelper().assertJsonEqual(json, this.getBodyAsString(), strict);
                }
                catch (Exception ex) {
                    throw new AssertionError("JSON parsing error", ex);
                }
            });
            return this;
        }

        @Override
        public WebTestClient.BodyContentSpec xml(String expectedXml) {
            this.result.assertWithDiagnostics(() -> {
                try {
                    new XmlExpectationsHelper().assertXmlEqual(expectedXml, this.getBodyAsString());
                }
                catch (Exception ex) {
                    throw new AssertionError("XML parsing error", ex);
                }
            });
            return this;
        }

        @Override
        public JsonPathAssertions jsonPath(String expression, Object ... args) {
            return new JsonPathAssertions(this, this.getBodyAsString(), expression, args);
        }

        @Override
        public XpathAssertions xpath(String expression, @Nullable Map<String, String> namespaces, Object ... args) {
            return new XpathAssertions(this, expression, namespaces, args);
        }

        private String getBodyAsString() {
            byte[] body2 = this.result.getResponseBody();
            if (body2 == null || body2.length == 0) {
                return "";
            }
            Charset charset = Optional.ofNullable(this.result.getResponseHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
            return new String(body2, charset);
        }

        @Override
        public WebTestClient.BodyContentSpec consumeWith(Consumer<EntityExchangeResult<byte[]>> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result));
            return this;
        }

        @Override
        public EntityExchangeResult<byte[]> returnResult() {
            return this.result;
        }
    }

    private static class DefaultListBodySpec<E>
    extends DefaultBodySpec<List<E>, WebTestClient.ListBodySpec<E>>
    implements WebTestClient.ListBodySpec<E> {
        DefaultListBodySpec(EntityExchangeResult<List<E>> result) {
            super(result);
        }

        @Override
        public WebTestClient.ListBodySpec<E> hasSize(int size) {
            List actual = (List)this.getResult().getResponseBody();
            String message = "Response body does not contain " + size + " elements";
            this.getResult().assertWithDiagnostics(() -> AssertionErrors.assertEquals(message, size, actual != null ? actual.size() : 0));
            return this;
        }

        @Override
        public WebTestClient.ListBodySpec<E> contains(E ... elements) {
            List expected = Arrays.asList(elements);
            List actual = (List)this.getResult().getResponseBody();
            String message = "Response body does not contain " + String.valueOf(expected);
            this.getResult().assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, actual != null && actual.containsAll(expected)));
            return this;
        }

        @Override
        public WebTestClient.ListBodySpec<E> doesNotContain(E ... elements) {
            List expected = Arrays.asList(elements);
            List actual = (List)this.getResult().getResponseBody();
            String message = "Response body should not have contained " + String.valueOf(expected);
            this.getResult().assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, actual == null || !actual.containsAll(expected)));
            return this;
        }

        @Override
        public EntityExchangeResult<List<E>> returnResult() {
            return this.getResult();
        }
    }

    private static class DefaultBodySpec<B, S extends WebTestClient.BodySpec<B, S>>
    implements WebTestClient.BodySpec<B, S> {
        private final EntityExchangeResult<B> result;

        DefaultBodySpec(EntityExchangeResult<B> result) {
            this.result = result;
        }

        protected EntityExchangeResult<B> getResult() {
            return this.result;
        }

        @Override
        public <T extends S> T isEqualTo(B expected) {
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Response body", expected, this.result.getResponseBody()));
            return this.self();
        }

        @Override
        public <T extends S> T value(Matcher<? super B> matcher) {
            this.result.assertWithDiagnostics(() -> MatcherAssert.assertThat(this.result.getResponseBody(), (Matcher)matcher));
            return this.self();
        }

        @Override
        public <T extends S, R> T value(Function<B, R> bodyMapper, Matcher<? super R> matcher) {
            this.result.assertWithDiagnostics(() -> {
                B body2 = this.result.getResponseBody();
                MatcherAssert.assertThat(bodyMapper.apply(body2), (Matcher)matcher);
            });
            return this.self();
        }

        @Override
        public <T extends S> T value(Consumer<B> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result.getResponseBody()));
            return this.self();
        }

        @Override
        public <T extends S> T consumeWith(Consumer<EntityExchangeResult<B>> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result));
            return this.self();
        }

        private <T extends S> T self() {
            return (T)this;
        }

        @Override
        public EntityExchangeResult<B> returnResult() {
            return this.result;
        }
    }

    private static class DefaultResponseSpec
    implements WebTestClient.ResponseSpec {
        private final ExchangeResult exchangeResult;
        private final ClientResponse response;
        private final Consumer<EntityExchangeResult<?>> entityResultConsumer;
        private final Duration timeout;

        DefaultResponseSpec(ExchangeResult exchangeResult, ClientResponse response, Consumer<EntityExchangeResult<?>> entityResultConsumer, Duration timeout) {
            this.exchangeResult = exchangeResult;
            this.response = response;
            this.entityResultConsumer = entityResultConsumer;
            this.timeout = timeout;
        }

        @Override
        public StatusAssertions expectStatus() {
            return new StatusAssertions(this.exchangeResult, this);
        }

        @Override
        public HeaderAssertions expectHeader() {
            return new HeaderAssertions(this.exchangeResult, this);
        }

        @Override
        public CookieAssertions expectCookie() {
            return new CookieAssertions(this.exchangeResult, this);
        }

        @Override
        public <B> WebTestClient.BodySpec<B, ?> expectBody(Class<B> bodyType) {
            Object body2 = this.response.bodyToMono(bodyType).block(this.timeout);
            EntityExchangeResult<Object> entityResult = this.initEntityExchangeResult(body2);
            return new DefaultBodySpec(entityResult);
        }

        @Override
        public <B> WebTestClient.BodySpec<B, ?> expectBody(ParameterizedTypeReference<B> bodyType) {
            Object body2 = this.response.bodyToMono(bodyType).block(this.timeout);
            EntityExchangeResult<Object> entityResult = this.initEntityExchangeResult(body2);
            return new DefaultBodySpec(entityResult);
        }

        @Override
        public <E> WebTestClient.ListBodySpec<E> expectBodyList(Class<E> elementType) {
            return this.getListBodySpec(this.response.bodyToFlux(elementType));
        }

        @Override
        public <E> WebTestClient.ListBodySpec<E> expectBodyList(ParameterizedTypeReference<E> elementType) {
            Flux flux = this.response.bodyToFlux(elementType);
            return this.getListBodySpec(flux);
        }

        private <E> WebTestClient.ListBodySpec<E> getListBodySpec(Flux<E> flux) {
            List body2 = (List)flux.collectList().block(this.timeout);
            EntityExchangeResult entityResult = this.initEntityExchangeResult(body2);
            return new DefaultListBodySpec(entityResult);
        }

        @Override
        public WebTestClient.BodyContentSpec expectBody() {
            ByteArrayResource resource = (ByteArrayResource)this.response.bodyToMono(ByteArrayResource.class).block(this.timeout);
            byte[] body2 = resource != null ? resource.getByteArray() : null;
            EntityExchangeResult<byte[]> entityResult = this.initEntityExchangeResult(body2);
            return new DefaultBodyContentSpec(entityResult);
        }

        private <B> EntityExchangeResult<B> initEntityExchangeResult(@Nullable B body2) {
            EntityExchangeResult result = new EntityExchangeResult(this.exchangeResult, body2);
            result.assertWithDiagnostics(() -> this.entityResultConsumer.accept(result));
            return result;
        }

        @Override
        public <T> FluxExchangeResult<T> returnResult(Class<T> elementClass) {
            Flux body2;
            if (elementClass.equals(Void.class)) {
                this.response.releaseBody().block();
                body2 = Flux.empty();
            } else {
                body2 = this.response.bodyToFlux(elementClass);
            }
            return new FluxExchangeResult(this.exchangeResult, body2);
        }

        @Override
        public <T> FluxExchangeResult<T> returnResult(ParameterizedTypeReference<T> elementTypeRef) {
            Flux body2;
            if (elementTypeRef.getType().equals(Void.class)) {
                this.response.releaseBody().block();
                body2 = Flux.empty();
            } else {
                body2 = this.response.bodyToFlux(elementTypeRef);
            }
            return new FluxExchangeResult(this.exchangeResult, body2);
        }

        @Override
        public WebTestClient.ResponseSpec expectAll(WebTestClient.ResponseSpec.ResponseSpecConsumer ... consumers) {
            ExceptionCollector exceptionCollector = new ExceptionCollector();
            for (WebTestClient.ResponseSpec.ResponseSpecConsumer consumer : consumers) {
                exceptionCollector.execute(() -> consumer.accept(this));
            }
            try {
                exceptionCollector.assertEmpty();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AssertionError(ex.getMessage(), ex);
            }
            return this;
        }
    }
}

