/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestConstructor;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.PropertyProvider;
import org.springframework.util.ClassUtils;

public abstract class TestConstructorUtils {
    private static final Log logger = LogFactory.getLog(TestConstructorUtils.class);
    private static final Set<Class<? extends Annotation>> autowiredAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>(2);

    private TestConstructorUtils() {
    }

    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass) {
        return TestConstructorUtils.isAutowirableConstructor(executable, testClass, null);
    }

    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass) {
        return TestConstructorUtils.isAutowirableConstructor(constructor, testClass, null);
    }

    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass, @Nullable PropertyProvider fallbackPropertyProvider) {
        Constructor constructor;
        return executable instanceof Constructor && TestConstructorUtils.isAutowirableConstructor(constructor = (Constructor)executable, testClass, fallbackPropertyProvider);
    }

    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass, @Nullable PropertyProvider fallbackPropertyProvider) {
        if (TestConstructorUtils.isAnnotatedWithAutowiredOrInject(constructor)) {
            return true;
        }
        TestConstructor.AutowireMode autowireMode = null;
        TestConstructor testConstructor = TestContextAnnotationUtils.findMergedAnnotation(testClass, TestConstructor.class);
        if (testConstructor != null) {
            autowireMode = testConstructor.autowireMode();
        } else {
            String value = SpringProperties.getProperty((String)"spring.test.constructor.autowire.mode");
            autowireMode = TestConstructor.AutowireMode.from(value);
            if (autowireMode == null && fallbackPropertyProvider != null) {
                value = fallbackPropertyProvider.get("spring.test.constructor.autowire.mode");
                autowireMode = TestConstructor.AutowireMode.from(value);
            }
        }
        return autowireMode == TestConstructor.AutowireMode.ALL;
    }

    private static boolean isAnnotatedWithAutowiredOrInject(Constructor<?> constructor) {
        return autowiredAnnotationTypes.stream().anyMatch(annotationType -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)constructor, (Class)annotationType));
    }

    static {
        autowiredAnnotationTypes.add(Autowired.class);
        ClassLoader classLoader = TestConstructorUtils.class.getClassLoader();
        try {
            autowiredAnnotationTypes.add(ClassUtils.forName((String)"jakarta.inject.Inject", (ClassLoader)classLoader));
            logger.trace((Object)"'jakarta.inject.Inject' annotation found and supported for autowiring");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            autowiredAnnotationTypes.add(ClassUtils.forName((String)"javax.inject.Inject", (ClassLoader)classLoader));
            logger.trace((Object)"'javax.inject.Inject' annotation found and supported for autowiring");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

