/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertySourceDescriptor;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ClassUtils;

class MergedContextConfigurationRuntimeHints {
    private static final String SLASH = "/";
    private static final String WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME = "org.springframework.test.context.web.WebMergedContextConfiguration";
    private static final String GET_RESOURCE_BASE_PATH_METHOD_NAME = "getResourceBasePath";
    private static final Class<?> webMergedContextConfigurationClass = MergedContextConfigurationRuntimeHints.loadWebMergedContextConfigurationClass();
    private static final Method getResourceBasePathMethod = MergedContextConfigurationRuntimeHints.loadGetResourceBasePathMethod();

    MergedContextConfigurationRuntimeHints() {
    }

    public void registerHints(RuntimeHints runtimeHints, MergedContextConfiguration mergedConfig, ClassLoader classLoader) {
        ContextLoader contextLoader = mergedConfig.getContextLoader();
        if (contextLoader != null) {
            this.registerDeclaredConstructors(contextLoader.getClass(), runtimeHints);
        }
        mergedConfig.getContextInitializerClasses().forEach(clazz -> this.registerDeclaredConstructors((Class<?>)clazz, runtimeHints));
        this.registerClasspathResources(mergedConfig.getLocations(), runtimeHints, classLoader);
        for (PropertySourceDescriptor descriptor : mergedConfig.getPropertySourceDescriptors()) {
            this.registerClasspathResources(descriptor.locations().stream(), runtimeHints, classLoader);
            Class factoryClass = descriptor.propertySourceFactory();
            if (factoryClass == null) continue;
            this.registerDeclaredConstructors(factoryClass, runtimeHints);
        }
        if (webMergedContextConfigurationClass.isInstance(mergedConfig)) {
            String resourceBasePath = null;
            try {
                resourceBasePath = (String)getResourceBasePathMethod.invoke((Object)mergedConfig, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to invoke WebMergedContextConfiguration#getResourceBasePath()", ex);
            }
            this.registerClasspathResourceDirectoryStructure(resourceBasePath, runtimeHints);
        }
    }

    private void registerDeclaredConstructors(Class<?> type, RuntimeHints runtimeHints) {
        runtimeHints.reflection().registerType(type, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
    }

    private void registerClasspathResources(String[] locations, RuntimeHints runtimeHints, ClassLoader classLoader) {
        this.registerClasspathResources(Arrays.stream(locations), runtimeHints, classLoader);
    }

    private void registerClasspathResources(Stream<String> locations, RuntimeHints runtimeHints, ClassLoader classLoader) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(classLoader);
        ResourceHints resourceHints = runtimeHints.resources();
        locations.map(arg_0 -> ((DefaultResourceLoader)resourceLoader).getResource(arg_0)).filter(ClassPathResource.class::isInstance).filter(Resource::exists).forEach(arg_0 -> ((ResourceHints)resourceHints).registerResource(arg_0));
    }

    private void registerClasspathResourceDirectoryStructure(String directory, RuntimeHints runtimeHints) {
        if (directory.startsWith("classpath:")) {
            Object pattern = directory.substring("classpath:".length());
            if (((String)pattern).startsWith(SLASH)) {
                pattern = ((String)pattern).substring(1);
            }
            if (!((String)pattern).endsWith(SLASH)) {
                pattern = (String)pattern + SLASH;
            }
            pattern = (String)pattern + "*";
            runtimeHints.resources().registerPattern((String)pattern);
        }
    }

    private static Class<?> loadWebMergedContextConfigurationClass() {
        try {
            return ClassUtils.forName((String)WEB_MERGED_CONTEXT_CONFIGURATION_CLASS_NAME, (ClassLoader)MergedContextConfigurationRuntimeHints.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError ex) {
            throw new IllegalStateException("Failed to load class org.springframework.test.context.web.WebMergedContextConfiguration", ex);
        }
    }

    private static Method loadGetResourceBasePathMethod() {
        try {
            return webMergedContextConfigurationClass.getMethod(GET_RESOURCE_BASE_PATH_METHOD_NAME, new Class[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to load method WebMergedContextConfiguration#getResourceBasePath()", ex);
        }
    }
}

