/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.test.context.aot.AotTestAttributes;
import org.springframework.test.context.aot.TestAotDetector;
import org.springframework.util.Assert;

class DefaultAotTestAttributes
implements AotTestAttributes {
    private final Map<String, String> attributes;

    DefaultAotTestAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setAttribute(String name, String value) {
        DefaultAotTestAttributes.assertNotInAotRuntime();
        Assert.notNull((Object)value, (String)"'value' must not be null");
        Assert.isTrue((!this.attributes.containsKey(name) ? 1 : 0) != 0, () -> "AOT attributes cannot be overridden. Name '%s' is already in use.".formatted(name));
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        DefaultAotTestAttributes.assertNotInAotRuntime();
        this.attributes.remove(name);
    }

    @Override
    @Nullable
    public String getString(String name) {
        return this.attributes.get(name);
    }

    private static void assertNotInAotRuntime() {
        if (TestAotDetector.useGeneratedArtifacts()) {
            throw new UnsupportedOperationException("AOT attributes cannot be modified during AOT run-time execution");
        }
    }
}

