/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.beans.factory.support.StaticListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

class StubWebApplicationContext
implements WebApplicationContext {
    private final ServletContext servletContext;
    private final StubBeanFactory beanFactory = new StubBeanFactory();
    private final String id = ObjectUtils.identityToString((Object)this);
    private final String displayName = ObjectUtils.identityToString((Object)this);
    private final long startupDate = System.currentTimeMillis();
    private final Environment environment = new StandardEnvironment();
    private final MessageSource messageSource = new DelegatingMessageSource();
    private final ResourcePatternResolver resourcePatternResolver;

    public StubWebApplicationContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.resourcePatternResolver = new ServletContextResourcePatternResolver(servletContext);
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return this.beanFactory;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getId() {
        return this.id;
    }

    public String getApplicationName() {
        return "";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getStartupDate() {
        return this.startupDate;
    }

    public ApplicationContext getParent() {
        return null;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void addBean(String name, Object bean) {
        this.beanFactory.addBean(name, bean);
    }

    public void addBeans(@Nullable List<?> beans) {
        if (beans != null) {
            for (Object bean : beans) {
                String name = bean.getClass().getName() + "#" + ObjectUtils.getIdentityHexString(bean);
                this.beanFactory.addBean(name, bean);
            }
        }
    }

    public Object getBean(String name) throws BeansException {
        return this.beanFactory.getBean(name);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)this.beanFactory.getBean(name, requiredType);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.beanFactory.getBean(name, args);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)this.beanFactory.getBean(requiredType);
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        return (T)this.beanFactory.getBean(requiredType, args);
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) {
        return this.beanFactory.getBeanProvider(requiredType);
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        return this.beanFactory.getBeanProvider(requiredType);
    }

    public boolean containsBean(String name) {
        return this.beanFactory.containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isSingleton(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isPrototype(name);
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isTypeMatch(name, typeToMatch);
    }

    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        return this.beanFactory.isTypeMatch(name, typeToMatch);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.beanFactory.getType(name);
    }

    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        return this.beanFactory.getType(name, allowFactoryBeanInit);
    }

    public String[] getAliases(String name) {
        return this.beanFactory.getAliases(name);
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beanFactory.containsBeanDefinition(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beanFactory.getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.beanFactory.getBeanDefinitionNames();
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType, boolean allowEagerInit) {
        return this.beanFactory.getBeanProvider(requiredType, allowEagerInit);
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType, boolean allowEagerInit) {
        return this.beanFactory.getBeanProvider(requiredType, allowEagerInit);
    }

    public String[] getBeanNamesForType(@Nullable ResolvableType type) {
        return this.beanFactory.getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(@Nullable ResolvableType type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.beanFactory.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
    }

    public String[] getBeanNamesForType(@Nullable Class<?> type) {
        return this.beanFactory.getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(@Nullable Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.beanFactory.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
    }

    public <T> Map<String, T> getBeansOfType(@Nullable Class<T> type) throws BeansException {
        return this.beanFactory.getBeansOfType(type);
    }

    public <T> Map<String, T> getBeansOfType(@Nullable Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return this.beanFactory.getBeansOfType(type, includeNonSingletons, allowEagerInit);
    }

    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        return this.beanFactory.getBeanNamesForAnnotation(annotationType);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        return this.beanFactory.getBeansWithAnnotation(annotationType);
    }

    @Nullable
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        return (A)this.beanFactory.findAnnotationOnBean(beanName, annotationType);
    }

    @Nullable
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        return (A)this.beanFactory.findAnnotationOnBean(beanName, annotationType, allowFactoryBeanInit);
    }

    public BeanFactory getParentBeanFactory() {
        return null;
    }

    public boolean containsLocalBean(String name) {
        return this.beanFactory.containsBean(name);
    }

    public String getMessage(String code, @Nullable Object[] args, @Nullable String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, @Nullable Object[] args, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, locale);
    }

    @Nullable
    public ClassLoader getClassLoader() {
        return ClassUtils.getDefaultClassLoader();
    }

    public Resource getResource(String location) {
        return this.resourcePatternResolver.getResource(location);
    }

    public void publishEvent(ApplicationEvent event) {
    }

    public void publishEvent(Object event) {
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return this.resourcePatternResolver.getResources(locationPattern);
    }

    private class StubBeanFactory
    extends StaticListableBeanFactory
    implements AutowireCapableBeanFactory {
        private StubBeanFactory() {
        }

        public Object initializeBean(Object existingBean, String beanName) throws BeansException {
            if (existingBean instanceof ApplicationContextAware) {
                ((ApplicationContextAware)existingBean).setApplicationContext((ApplicationContext)StubWebApplicationContext.this);
            }
            return existingBean;
        }

        public <T> T createBean(Class<T> beanClass) {
            return (T)BeanUtils.instantiateClass(beanClass);
        }

        public Object createBean(Class<?> beanClass, int autowireMode, boolean dependencyCheck) {
            return BeanUtils.instantiateClass(beanClass);
        }

        public Object autowire(Class<?> beanClass, int autowireMode, boolean dependencyCheck) {
            return BeanUtils.instantiateClass(beanClass);
        }

        public void autowireBean(Object existingBean) throws BeansException {
        }

        public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) {
        }

        public Object configureBean(Object existingBean, String beanName) {
            return existingBean;
        }

        public <T> NamedBeanHolder<T> resolveNamedBean(Class<T> requiredType) throws BeansException {
            throw new UnsupportedOperationException("Dependency resolution not supported");
        }

        public Object resolveBeanByName(String name, DependencyDescriptor descriptor) throws BeansException {
            throw new UnsupportedOperationException("Dependency resolution not supported");
        }

        @Nullable
        public Object resolveDependency(DependencyDescriptor descriptor, @Nullable String requestingBeanName) {
            throw new UnsupportedOperationException("Dependency resolution not supported");
        }

        @Nullable
        public Object resolveDependency(DependencyDescriptor descriptor, @Nullable String requestingBeanName, @Nullable Set<String> autowiredBeanNames, @Nullable TypeConverter typeConverter) {
            throw new UnsupportedOperationException("Dependency resolution not supported");
        }

        public void applyBeanPropertyValues(Object existingBean, String beanName) throws BeansException {
        }

        public Object applyBeanPostProcessorsBeforeInitialization(Object existingBean, String beanName) {
            return existingBean;
        }

        public Object applyBeanPostProcessorsAfterInitialization(Object existingBean, String beanName) {
            return existingBean;
        }

        public void destroyBean(Object existingBean) {
        }
    }
}

