/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import jakarta.servlet.Filter;
import java.util.function.Supplier;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.servlet.DispatcherServletCustomizer;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.client.ApplicationContextMockMvcSpec;
import org.springframework.test.web.servlet.client.MockMvcHttpConnector;
import org.springframework.test.web.servlet.client.StandaloneMockMvcSpec;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPatternParser;

public interface MockMvcWebTestClient {
    public static ControllerSpec bindToController(Object ... controllers) {
        return new StandaloneMockMvcSpec(controllers);
    }

    public static MockMvcServerSpec<?> bindToApplicationContext(WebApplicationContext context) {
        return new ApplicationContextMockMvcSpec(context);
    }

    public static WebTestClient.Builder bindTo(MockMvc mockMvc) {
        MockMvcHttpConnector connector = new MockMvcHttpConnector(mockMvc);
        return WebTestClient.bindToServer(connector);
    }

    public static ResultActions resultActionsFor(ExchangeResult exchangeResult) {
        final Object serverResult = exchangeResult.getMockServerResult();
        Assert.notNull((Object)serverResult, (String)"No MvcResult");
        Assert.isInstanceOf(MvcResult.class, (Object)serverResult);
        return new ResultActions(){

            @Override
            public ResultActions andExpect(ResultMatcher matcher) throws Exception {
                matcher.match((MvcResult)serverResult);
                return this;
            }

            @Override
            public ResultActions andDo(ResultHandler handler) throws Exception {
                handler.handle((MvcResult)serverResult);
                return this;
            }

            @Override
            public MvcResult andReturn() {
                return (MvcResult)serverResult;
            }
        };
    }

    public static interface ControllerSpec
    extends MockMvcServerSpec<ControllerSpec> {
        public ControllerSpec controllerAdvice(Object ... var1);

        public ControllerSpec messageConverters(HttpMessageConverter<?> ... var1);

        public ControllerSpec validator(Validator var1);

        public ControllerSpec conversionService(FormattingConversionService var1);

        public ControllerSpec interceptors(HandlerInterceptor ... var1);

        public ControllerSpec mappedInterceptors(@Nullable String[] var1, HandlerInterceptor ... var2);

        public ControllerSpec contentNegotiationManager(ContentNegotiationManager var1);

        public ControllerSpec asyncRequestTimeout(long var1);

        public ControllerSpec customArgumentResolvers(HandlerMethodArgumentResolver ... var1);

        public ControllerSpec customReturnValueHandlers(HandlerMethodReturnValueHandler ... var1);

        public ControllerSpec handlerExceptionResolvers(HandlerExceptionResolver ... var1);

        public ControllerSpec viewResolvers(ViewResolver ... var1);

        public ControllerSpec singleView(View var1);

        public ControllerSpec localeResolver(LocaleResolver var1);

        public ControllerSpec flashMapManager(FlashMapManager var1);

        public ControllerSpec patternParser(PathPatternParser var1);

        public ControllerSpec useTrailingSlashPatternMatch(boolean var1);

        public ControllerSpec placeholderValue(String var1, String var2);

        public ControllerSpec customHandlerMapping(Supplier<RequestMappingHandlerMapping> var1);
    }

    public static interface MockMvcServerSpec<B extends MockMvcServerSpec<B>> {
        public <T extends B> T filters(Filter ... var1);

        public <T extends B> T filter(Filter var1, String ... var2);

        public <T extends B> T defaultRequest(RequestBuilder var1);

        public <T extends B> T alwaysExpect(ResultMatcher var1);

        public <T extends B> T dispatchOptions(boolean var1);

        public <T extends B> T dispatcherServletCustomizer(DispatcherServletCustomizer var1);

        public <T extends B> T apply(MockMvcConfigurer var1);

        public WebTestClient.Builder configureClient();

        public WebTestClient build();
    }
}

