/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.response;

import java.io.IOException;
import java.net.URI;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.test.web.client.response.DefaultResponseCreator;

public abstract class MockRestResponseCreators {
    public static DefaultResponseCreator withSuccess() {
        return new DefaultResponseCreator((HttpStatusCode)HttpStatus.OK);
    }

    public static DefaultResponseCreator withSuccess(String body2, @Nullable MediaType contentType) {
        DefaultResponseCreator creator = new DefaultResponseCreator((HttpStatusCode)HttpStatus.OK).body(body2);
        return contentType != null ? creator.contentType(contentType) : creator;
    }

    public static DefaultResponseCreator withSuccess(byte[] body2, @Nullable MediaType contentType) {
        DefaultResponseCreator creator = new DefaultResponseCreator((HttpStatusCode)HttpStatus.OK).body(body2);
        return contentType != null ? creator.contentType(contentType) : creator;
    }

    public static DefaultResponseCreator withSuccess(Resource body2, @Nullable MediaType contentType) {
        DefaultResponseCreator creator = new DefaultResponseCreator((HttpStatusCode)HttpStatus.OK).body(body2);
        return contentType != null ? creator.contentType(contentType) : creator;
    }

    public static DefaultResponseCreator withCreatedEntity(URI location) {
        return new DefaultResponseCreator((HttpStatusCode)HttpStatus.CREATED).location(location);
    }

    public static DefaultResponseCreator withNoContent() {
        return new DefaultResponseCreator((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    public static DefaultResponseCreator withBadRequest() {
        return new DefaultResponseCreator((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public static DefaultResponseCreator withUnauthorizedRequest() {
        return new DefaultResponseCreator((HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    public static DefaultResponseCreator withServerError() {
        return new DefaultResponseCreator((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static DefaultResponseCreator withStatus(HttpStatusCode status) {
        return new DefaultResponseCreator(status);
    }

    public static DefaultResponseCreator withRawStatus(int status) {
        return new DefaultResponseCreator(status);
    }

    public static ResponseCreator withException(IOException ex) {
        return request2 -> {
            throw ex;
        };
    }
}

