/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import jakarta.servlet.Filter;
import jakarta.servlet.ServletContext;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.test.web.servlet.DispatcherServletCustomizer;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MockMvcBuilderSupport;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.request.ConfigurableSmartRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.test.web.servlet.setup.PatternMappingFilterProxy;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractMockMvcBuilder<B extends AbstractMockMvcBuilder<B>>
extends MockMvcBuilderSupport
implements ConfigurableMockMvcBuilder<B> {
    private final List<Filter> filters = new ArrayList<Filter>();
    @Nullable
    private RequestBuilder defaultRequestBuilder;
    @Nullable
    private Charset defaultResponseCharacterEncoding;
    private final List<ResultMatcher> globalResultMatchers = new ArrayList<ResultMatcher>();
    private final List<ResultHandler> globalResultHandlers = new ArrayList<ResultHandler>();
    private final List<DispatcherServletCustomizer> dispatcherServletCustomizers = new ArrayList<DispatcherServletCustomizer>();
    private final List<MockMvcConfigurer> configurers = new ArrayList<MockMvcConfigurer>(4);

    @Override
    public final <T extends B> T addFilters(Filter ... filters) {
        Assert.notNull((Object)filters, (String)"filters cannot be null");
        for (Filter f : filters) {
            Assert.notNull((Object)f, (String)"filters cannot contain null values");
            this.filters.add(f);
        }
        return this.self();
    }

    @Override
    public final <T extends B> T addFilter(Filter filter, String ... urlPatterns) {
        Assert.notNull((Object)filter, (String)"filter cannot be null");
        Assert.notNull((Object)urlPatterns, (String)"urlPatterns cannot be null");
        if (urlPatterns.length > 0) {
            filter = new PatternMappingFilterProxy(filter, urlPatterns);
        }
        this.filters.add(filter);
        return this.self();
    }

    @Override
    public final <T extends B> T defaultRequest(RequestBuilder requestBuilder) {
        this.defaultRequestBuilder = requestBuilder;
        return this.self();
    }

    @Override
    public final <T extends B> T defaultResponseCharacterEncoding(Charset defaultResponseCharacterEncoding) {
        this.defaultResponseCharacterEncoding = defaultResponseCharacterEncoding;
        return this.self();
    }

    @Override
    public final <T extends B> T alwaysExpect(ResultMatcher resultMatcher) {
        this.globalResultMatchers.add(resultMatcher);
        return this.self();
    }

    @Override
    public final <T extends B> T alwaysDo(ResultHandler resultHandler) {
        this.globalResultHandlers.add(resultHandler);
        return this.self();
    }

    @Override
    public final <T extends B> T addDispatcherServletCustomizer(DispatcherServletCustomizer customizer) {
        this.dispatcherServletCustomizers.add(customizer);
        return this.self();
    }

    @Override
    public final <T extends B> T dispatchOptions(boolean dispatchOptions) {
        return (T)this.addDispatcherServletCustomizer(dispatcherServlet -> dispatcherServlet.setDispatchOptionsRequest(dispatchOptions));
    }

    @Override
    public final <T extends B> T apply(MockMvcConfigurer configurer) {
        configurer.afterConfigurerAdded(this);
        this.configurers.add(configurer);
        return this.self();
    }

    protected <T extends B> T self() {
        return (T)this;
    }

    @Override
    public final MockMvc build() {
        WebApplicationContext wac = this.initWebAppContext();
        ServletContext servletContext = wac.getServletContext();
        MockServletConfig mockServletConfig = new MockServletConfig(servletContext);
        for (MockMvcConfigurer configurer : this.configurers) {
            RequestPostProcessor processor = configurer.beforeMockMvcCreated(this, wac);
            if (processor == null) continue;
            if (this.defaultRequestBuilder == null) {
                this.defaultRequestBuilder = MockMvcRequestBuilders.get("/", new Object[0]);
            }
            if (!(this.defaultRequestBuilder instanceof ConfigurableSmartRequestBuilder)) continue;
            ((ConfigurableSmartRequestBuilder)this.defaultRequestBuilder).with(processor);
        }
        Filter[] filterArray = this.filters.toArray(new Filter[0]);
        return super.createMockMvc(filterArray, mockServletConfig, wac, this.defaultRequestBuilder, this.defaultResponseCharacterEncoding, this.globalResultMatchers, this.globalResultHandlers, this.dispatcherServletCustomizers);
    }

    protected abstract WebApplicationContext initWebAppContext();
}

