/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.util.Assert;

public class MockMvcClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final MockMvc mockMvc;

    public MockMvcClientHttpRequestFactory(MockMvc mockMvc) {
        Assert.notNull((Object)mockMvc, (String)"MockMvc must not be null");
        this.mockMvc = mockMvc;
    }

    public ClientHttpRequest createRequest(final URI uri, final HttpMethod httpMethod) {
        return new MockClientHttpRequest(httpMethod, uri){

            @Override
            public ClientHttpResponse executeInternal() {
                return MockMvcClientHttpRequestFactory.this.getClientHttpResponse(httpMethod, uri, this.getHeaders(), this.getBodyAsBytes());
            }
        };
    }

    private ClientHttpResponse getClientHttpResponse(HttpMethod httpMethod, URI uri, HttpHeaders requestHeaders, byte[] requestBody) {
        try {
            MockHttpServletResponse servletResponse = this.mockMvc.perform(MockMvcRequestBuilders.request(httpMethod, uri).content(requestBody).headers(requestHeaders)).andReturn().getResponse();
            HttpStatus status = HttpStatus.valueOf((int)servletResponse.getStatus());
            byte[] body2 = servletResponse.getContentAsByteArray();
            MockClientHttpResponse clientResponse = new MockClientHttpResponse(body2, status);
            clientResponse.getHeaders().putAll((Map)this.getResponseHeaders(servletResponse));
            return clientResponse;
        }
        catch (Exception ex) {
            byte[] body3 = ex.toString().getBytes(StandardCharsets.UTF_8);
            return new MockClientHttpResponse(body3, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private HttpHeaders getResponseHeaders(MockHttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        for (String name : response.getHeaderNames()) {
            Collection values = response.getHeaders(name);
            for (String value : values) {
                headers.add(name, value);
            }
        }
        return headers;
    }
}

