/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.http.Cookie;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MockCookie
extends Cookie {
    private static final long serialVersionUID = 4312531139502726325L;
    @Nullable
    private ZonedDateTime expires;
    @Nullable
    private String sameSite;

    public MockCookie(String name, String value) {
        super(name, value);
    }

    public void setExpires(@Nullable ZonedDateTime expires) {
        this.expires = expires;
    }

    @Nullable
    public ZonedDateTime getExpires() {
        return this.expires;
    }

    public void setSameSite(@Nullable String sameSite) {
        this.sameSite = sameSite;
    }

    @Nullable
    public String getSameSite() {
        return this.sameSite;
    }

    public static MockCookie parse(String setCookieHeader) {
        Assert.notNull((Object)setCookieHeader, (String)"Set-Cookie header must not be null");
        String[] cookieParts = setCookieHeader.split("\\s*=\\s*", 2);
        Assert.isTrue((cookieParts.length == 2 ? 1 : 0) != 0, () -> "Invalid Set-Cookie header '" + setCookieHeader + "'");
        String name = cookieParts[0];
        String[] valueAndAttributes = cookieParts[1].split("\\s*;\\s*", 2);
        String value = valueAndAttributes[0];
        String[] attributes = valueAndAttributes.length > 1 ? valueAndAttributes[1].split("\\s*;\\s*") : new String[]{};
        MockCookie cookie = new MockCookie(name, value);
        for (String attribute : attributes) {
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)"Domain")) {
                cookie.setDomain(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)"Max-Age")) {
                cookie.setMaxAge(Integer.parseInt(MockCookie.extractAttributeValue(attribute, setCookieHeader)));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)"Expires")) {
                try {
                    cookie.setExpires(ZonedDateTime.parse(MockCookie.extractAttributeValue(attribute, setCookieHeader), DateTimeFormatter.RFC_1123_DATE_TIME));
                }
                catch (DateTimeException dateTimeException) {}
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)"Path")) {
                cookie.setPath(MockCookie.extractAttributeValue(attribute, setCookieHeader));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)"Secure")) {
                cookie.setSecure(true);
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)attribute, (String)"HttpOnly")) {
                cookie.setHttpOnly(true);
                continue;
            }
            if (!StringUtils.startsWithIgnoreCase((String)attribute, (String)"SameSite")) continue;
            cookie.setSameSite(MockCookie.extractAttributeValue(attribute, setCookieHeader));
        }
        return cookie;
    }

    private static String extractAttributeValue(String attribute, String header) {
        String[] nameAndValue = attribute.split("=");
        Assert.isTrue((nameAndValue.length == 2 ? 1 : 0) != 0, () -> "No value in attribute '" + nameAndValue[0] + "' for Set-Cookie header '" + header + "'");
        return nameAndValue[1];
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.getName()).append("value", (Object)this.getValue()).append("Path", (Object)this.getPath()).append("Domain", (Object)this.getDomain()).append("Version", this.getVersion()).append("Comment", (Object)this.getComment()).append("Secure", this.getSecure()).append("HttpOnly", this.isHttpOnly()).append("SameSite", (Object)this.sameSite).append("Max-Age", this.getMaxAge()).append("Expires", this.expires != null ? DateTimeFormatter.RFC_1123_DATE_TIME.format(this.expires) : null).toString();
    }
}

