/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.MockHttpInputMessage;
import org.springframework.util.Assert;

public class MockClientHttpResponse
extends MockHttpInputMessage
implements ClientHttpResponse {
    private final int statusCode;

    public MockClientHttpResponse(byte[] body2, HttpStatus statusCode) {
        super(body2);
        Assert.notNull((Object)statusCode, (String)"HttpStatus is required");
        this.statusCode = statusCode.value();
    }

    public MockClientHttpResponse(byte[] body2, int statusCode) {
        super(body2);
        this.statusCode = statusCode;
    }

    public MockClientHttpResponse(InputStream body2, HttpStatus statusCode) {
        super(body2);
        Assert.notNull((Object)statusCode, (String)"HttpStatus is required");
        this.statusCode = statusCode.value();
    }

    public MockClientHttpResponse(InputStream body2, int statusCode) {
        super(body2);
        this.statusCode = statusCode;
    }

    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf((int)this.statusCode);
    }

    public int getRawStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        HttpStatus status = HttpStatus.resolve((int)this.statusCode);
        return status != null ? status.getReasonPhrase() : "";
    }

    public void close() {
        try {
            this.getBody().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

