/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client.reactive;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpMethod httpMethod;
    private final URI url;
    private Flux<DataBuffer> body = Flux.error((Throwable)new IllegalStateException("The body is not set. Did handling complete with success? Is a custom \"writeHandler\" configured?"));
    private Function<Flux<DataBuffer>, Mono<Void>> writeHandler;

    public MockClientHttpRequest(HttpMethod httpMethod, String urlTemplate, Object ... vars) {
        this(httpMethod, UriComponentsBuilder.fromUriString((String)urlTemplate).buildAndExpand(vars).encode().toUri());
    }

    public MockClientHttpRequest(HttpMethod httpMethod, URI url) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.writeHandler = body2 -> {
            this.body = body2.cache();
            return this.body.then();
        };
    }

    public void setWriteHandler(Function<Flux<DataBuffer>, Mono<Void>> writeHandler) {
        Assert.notNull(writeHandler, (String)"'writeHandler' is required");
        this.writeHandler = writeHandler;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public URI getURI() {
        return this.url;
    }

    public DataBufferFactory bufferFactory() {
        return DefaultDataBufferFactory.sharedInstance;
    }

    protected void applyHeaders() {
    }

    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).forEach(cookie -> this.getHeaders().add("Cookie", cookie.toString()));
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
        return this.doCommit(() -> Mono.defer(() -> this.writeHandler.apply((Flux<DataBuffer>)Flux.from((Publisher)body2))));
    }

    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body2).flatMap(p -> p));
    }

    public Mono<Void> setComplete() {
        return this.writeWith((Publisher<? extends DataBuffer>)Flux.empty());
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public Mono<String> getBodyAsString() {
        Charset charset = Optional.ofNullable(this.getHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
        return DataBufferUtils.join(this.getBody()).map(buffer -> {
            String s = buffer.toString(charset);
            DataBufferUtils.release((DataBuffer)buffer);
            return s;
        }).defaultIfEmpty((Object)"");
    }
}

