/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.HttpHeadResponseDecorator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.mock.http.client.reactive.MockClientHttpRequest;
import org.springframework.mock.http.client.reactive.MockClientHttpResponse;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class HttpHandlerConnector
implements ClientHttpConnector {
    private static Log logger = LogFactory.getLog(HttpHandlerConnector.class);
    private final HttpHandler handler;

    public HttpHandlerConnector(HttpHandler handler) {
        Assert.notNull((Object)handler, (String)"HttpHandler is required");
        this.handler = handler;
    }

    public Mono<ClientHttpResponse> connect(HttpMethod httpMethod, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        MonoProcessor result = MonoProcessor.create();
        MockClientHttpRequest mockClientRequest = new MockClientHttpRequest(httpMethod, uri);
        MockServerHttpResponse mockServerResponse = new MockServerHttpResponse();
        mockClientRequest.setWriteHandler(requestBody -> {
            this.log("Invoking HttpHandler for ", httpMethod, uri);
            ServerHttpRequest mockServerRequest = this.adaptRequest(mockClientRequest, (Publisher<DataBuffer>)requestBody);
            ServerHttpResponse responseToUse = this.prepareResponse((ServerHttpResponse)mockServerResponse, mockServerRequest);
            this.handler.handle(mockServerRequest, responseToUse).subscribe(aVoid -> {}, arg_0 -> ((MonoProcessor)result).onError(arg_0));
            return Mono.empty();
        });
        mockServerResponse.setWriteHandler(responseBody -> Mono.fromRunnable(() -> {
            this.log("Creating client response for ", httpMethod, uri);
            result.onNext((Object)this.adaptResponse(mockServerResponse, (Flux<DataBuffer>)responseBody));
        }));
        this.log("Writing client request for ", httpMethod, uri);
        requestCallback.apply((ClientHttpRequest)mockClientRequest).subscribe(aVoid -> {}, arg_0 -> ((MonoProcessor)result).onError(arg_0));
        return result;
    }

    private void log(String message, HttpMethod httpMethod, URI uri) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("%s %s \"%s\"", message, httpMethod, uri));
        }
    }

    private ServerHttpRequest adaptRequest(MockClientHttpRequest request, Publisher<DataBuffer> body) {
        HttpMethod method = request.getMethod();
        URI uri = request.getURI();
        HttpHeaders headers = request.getHeaders();
        MultiValueMap cookies = request.getCookies();
        return ((MockServerHttpRequest.BodyBuilder)((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.method(method, uri).headers((MultiValueMap<String, String>)headers)).cookies((MultiValueMap<String, HttpCookie>)cookies)).body(body);
    }

    private ServerHttpResponse prepareResponse(ServerHttpResponse response, ServerHttpRequest request) {
        return request.getMethod() == HttpMethod.HEAD ? new HttpHeadResponseDecorator(response) : response;
    }

    private ClientHttpResponse adaptResponse(MockServerHttpResponse response, Flux<DataBuffer> body) {
        Integer status = response.getStatusCodeValue();
        MockClientHttpResponse clientResponse = new MockClientHttpResponse(status != null ? status : 200);
        clientResponse.getHeaders().putAll((Map)response.getHeaders());
        clientResponse.getCookies().putAll((Map)response.getCookies());
        clientResponse.setBody((Publisher<DataBuffer>)body);
        return clientResponse;
    }
}

