/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.web.servlet.ModelAndView;

public class ModelResultMatchers {
    protected ModelResultMatchers() {
    }

    public <T> ResultMatcher attribute(String name, Matcher<T> matcher) {
        return result -> {
            ModelAndView mav = this.getModelAndView(result);
            MatcherAssert.assertThat((String)("Model attribute '" + name + "'"), mav.getModel().get(name), (Matcher)matcher);
        };
    }

    public ResultMatcher attribute(String name, Object value) {
        return result -> {
            ModelAndView mav = this.getModelAndView(result);
            AssertionErrors.assertEquals("Model attribute '" + name + "'", value, mav.getModel().get(name));
        };
    }

    public ResultMatcher attributeExists(String ... names) {
        return result -> {
            ModelAndView mav = this.getModelAndView(result);
            for (String name : names) {
                AssertionErrors.assertTrue("Model attribute '" + name + "' does not exist", mav.getModel().get(name) != null);
            }
        };
    }

    public ResultMatcher attributeDoesNotExist(String ... names) {
        return result -> {
            ModelAndView mav = this.getModelAndView(result);
            for (String name : names) {
                AssertionErrors.assertTrue("Model attribute '" + name + "' exists", mav.getModel().get(name) == null);
            }
        };
    }

    public ResultMatcher attributeErrorCount(String name, int expectedCount) {
        return result -> {
            ModelAndView mav = this.getModelAndView(result);
            BindingResult errors = this.getBindingResult(mav, name);
            AssertionErrors.assertEquals("Binding/validation error count for attribute '" + name + "', ", expectedCount, errors.getErrorCount());
        };
    }

    public ResultMatcher attributeHasErrors(String ... names) {
        return mvcResult -> {
            ModelAndView mav = this.getModelAndView(mvcResult);
            for (String name : names) {
                BindingResult result = this.getBindingResult(mav, name);
                AssertionErrors.assertTrue("No errors for attribute '" + name + "'", result.hasErrors());
            }
        };
    }

    public ResultMatcher attributeHasNoErrors(String ... names) {
        return mvcResult -> {
            ModelAndView mav = this.getModelAndView(mvcResult);
            for (String name : names) {
                BindingResult result = this.getBindingResult(mav, name);
                AssertionErrors.assertTrue("Unexpected errors for attribute '" + name + "': " + result.getAllErrors(), !result.hasErrors());
            }
        };
    }

    public ResultMatcher attributeHasFieldErrors(String name, String ... fieldNames) {
        return mvcResult -> {
            ModelAndView mav = this.getModelAndView(mvcResult);
            BindingResult result = this.getBindingResult(mav, name);
            AssertionErrors.assertTrue("No errors for attribute '" + name + "'", result.hasErrors());
            for (String fieldName : fieldNames) {
                boolean hasFieldErrors = result.hasFieldErrors(fieldName);
                AssertionErrors.assertTrue("No errors for field '" + fieldName + "' of attribute '" + name + "'", hasFieldErrors);
            }
        };
    }

    public ResultMatcher attributeHasFieldErrorCode(String name, String fieldName, String error) {
        return mvcResult -> {
            ModelAndView mav = this.getModelAndView(mvcResult);
            BindingResult result = this.getBindingResult(mav, name);
            AssertionErrors.assertTrue("No errors for attribute '" + name + "'", result.hasErrors());
            FieldError fieldError = result.getFieldError(fieldName);
            if (fieldError == null) {
                AssertionErrors.fail("No errors for field '" + fieldName + "' of attribute '" + name + "'");
            }
            String code = fieldError.getCode();
            AssertionErrors.assertTrue("Expected error code '" + error + "' but got '" + code + "'", error.equals(code));
        };
    }

    public <T> ResultMatcher attributeHasFieldErrorCode(String name, String fieldName, Matcher<? super String> matcher) {
        return mvcResult -> {
            ModelAndView mav = this.getModelAndView(mvcResult);
            BindingResult result = this.getBindingResult(mav, name);
            AssertionErrors.assertTrue("No errors for attribute: [" + name + "]", result.hasErrors());
            FieldError fieldError = result.getFieldError(fieldName);
            if (fieldError == null) {
                AssertionErrors.fail("No errors for field '" + fieldName + "' of attribute '" + name + "'");
            }
            String code = fieldError.getCode();
            MatcherAssert.assertThat((String)("Field name '" + fieldName + "' of attribute '" + name + "'"), (Object)code, (Matcher)matcher);
        };
    }

    public <T> ResultMatcher errorCount(int expectedCount) {
        return result -> {
            int actualCount = this.getErrorCount(this.getModelAndView(result).getModelMap());
            AssertionErrors.assertEquals("Binding/validation error count", expectedCount, actualCount);
        };
    }

    public <T> ResultMatcher hasErrors() {
        return result -> {
            int count = this.getErrorCount(this.getModelAndView(result).getModelMap());
            AssertionErrors.assertTrue("Expected binding/validation errors", count != 0);
        };
    }

    public <T> ResultMatcher hasNoErrors() {
        return result -> {
            ModelAndView mav = this.getModelAndView(result);
            for (Object value : mav.getModel().values()) {
                if (!(value instanceof Errors)) continue;
                AssertionErrors.assertTrue("Unexpected binding/validation errors: " + value, !((Errors)value).hasErrors());
            }
        };
    }

    public <T> ResultMatcher size(int size) {
        return result -> {
            ModelAndView mav = this.getModelAndView(result);
            int actual = 0;
            for (String key : mav.getModel().keySet()) {
                if (key.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
                ++actual;
            }
            AssertionErrors.assertEquals("Model size", size, actual);
        };
    }

    private ModelAndView getModelAndView(MvcResult mvcResult) {
        ModelAndView mav = mvcResult.getModelAndView();
        if (mav == null) {
            AssertionErrors.fail("No ModelAndView found");
        }
        return mav;
    }

    private BindingResult getBindingResult(ModelAndView mav, String name) {
        BindingResult result = (BindingResult)mav.getModel().get(BindingResult.MODEL_KEY_PREFIX + name);
        if (result == null) {
            AssertionErrors.fail("No BindingResult for attribute: " + name);
        }
        return result;
    }

    private int getErrorCount(ModelMap model) {
        int count = 0;
        for (Object value : model.values()) {
            if (!(value instanceof Errors)) continue;
            count += ((Errors)value).getErrorCount();
        }
        return count;
    }
}

