/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import java.util.List;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.springframework.core.NestedRuntimeException;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.test.web.servlet.DispatcherServletCustomizer;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.TestDispatcherServlet;
import org.springframework.web.context.WebApplicationContext;

public abstract class MockMvcBuilderSupport {
    protected final MockMvc createMockMvc(Filter[] filters, MockServletConfig servletConfig, WebApplicationContext webAppContext, @Nullable RequestBuilder defaultRequestBuilder, List<ResultMatcher> globalResultMatchers, List<ResultHandler> globalResultHandlers, @Nullable List<DispatcherServletCustomizer> dispatcherServletCustomizers) {
        TestDispatcherServlet dispatcherServlet = new TestDispatcherServlet(webAppContext);
        if (dispatcherServletCustomizers != null) {
            for (DispatcherServletCustomizer customizers : dispatcherServletCustomizers) {
                customizers.customize(dispatcherServlet);
            }
        }
        try {
            dispatcherServlet.init(servletConfig);
        }
        catch (ServletException ex) {
            throw new MockMvcBuildException("Failed to initialize TestDispatcherServlet", ex);
        }
        MockMvc mockMvc = new MockMvc(dispatcherServlet, filters);
        mockMvc.setDefaultRequest(defaultRequestBuilder);
        mockMvc.setGlobalResultMatchers(globalResultMatchers);
        mockMvc.setGlobalResultHandlers(globalResultHandlers);
        return mockMvc;
    }

    private static class MockMvcBuildException
    extends NestedRuntimeException {
        public MockMvcBuildException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

