/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.Part;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class MockPart
implements Part {
    private final String name;
    @Nullable
    private final String filename;
    private final byte[] content;
    private final HttpHeaders headers = new HttpHeaders();

    public MockPart(String name, @Nullable byte[] content) {
        this(name, null, content);
    }

    public MockPart(String name, @Nullable String filename, InputStream content) throws IOException {
        this(name, filename, FileCopyUtils.copyToByteArray((InputStream)content));
    }

    private MockPart(String name, @Nullable String filename, @Nullable byte[] content) {
        Assert.hasLength((String)name, (String)"Name must not be null");
        this.name = name;
        this.filename = filename;
        this.content = content != null ? content : new byte[]{};
        this.headers.setContentDispositionFormData(name, filename);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getSubmittedFileName() {
        return this.filename;
    }

    @Nullable
    public String getContentType() {
        MediaType contentType = this.headers.getContentType();
        return contentType != null ? contentType.toString() : null;
    }

    public long getSize() {
        return this.content.length;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    @Nullable
    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    public Collection<String> getHeaders(String name) {
        List<String> headerValues = this.headers.get((Object)name);
        return headerValues != null ? headerValues : Collections.emptyList();
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void write(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void delete() throws IOException {
        throw new UnsupportedOperationException();
    }
}

