/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ClientHttpResponseDecorator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoProcessor;

class WiretapClientHttpResponse
extends ClientHttpResponseDecorator {
    private static final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();
    private final DataBuffer buffer;
    private final MonoProcessor<byte[]> body = MonoProcessor.create();

    public WiretapClientHttpResponse(ClientHttpResponse delegate) {
        super(delegate);
        this.buffer = bufferFactory.allocateBuffer();
    }

    public MonoProcessor<byte[]> getBodyContent() {
        return this.body;
    }

    public Flux<DataBuffer> getBody() {
        return super.getBody().doOnNext(xva$0 -> this.buffer.write(new DataBuffer[]{xva$0})).doOnError(arg_0 -> this.body.onError(arg_0)).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete);
    }

    private void handleOnComplete() {
        if (!this.body.isTerminated()) {
            byte[] bytes = new byte[this.buffer.readableByteCount()];
            this.buffer.read(bytes);
            this.body.onNext((Object)bytes);
        }
    }
}

