/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpRequestDecorator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

class WiretapClientHttpRequest
extends ClientHttpRequestDecorator {
    private static final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();
    private final DataBuffer buffer;
    private final MonoProcessor<byte[]> body = MonoProcessor.create();

    public WiretapClientHttpRequest(ClientHttpRequest delegate) {
        super(delegate);
        this.buffer = bufferFactory.allocateBuffer();
    }

    public MonoProcessor<byte[]> getBodyContent() {
        return this.body;
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> publisher) {
        return super.writeWith((Publisher)Flux.from(publisher).doOnNext(this::handleOnNext).doOnError(this::handleError).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete));
    }

    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> publisher) {
        return super.writeAndFlushWith((Publisher)Flux.from(publisher).map(p -> Flux.from((Publisher)p).doOnNext(this::handleOnNext).doOnError(this::handleError)).doOnError(this::handleError).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete));
    }

    public Mono<Void> setComplete() {
        this.handleOnComplete();
        return super.setComplete();
    }

    private void handleOnNext(DataBuffer buffer) {
        this.buffer.write(new DataBuffer[]{buffer});
    }

    private void handleError(Throwable ex) {
        if (!this.body.isTerminated()) {
            this.body.onError(ex);
        }
    }

    private void handleOnComplete() {
        if (!this.body.isTerminated()) {
            byte[] bytes = new byte[this.buffer.readableByteCount()];
            this.buffer.read(bytes);
            this.body.onNext((Object)bytes);
        }
    }
}

