/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.time.Duration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.test.web.reactive.server.DefaultWebTestClient;
import org.springframework.test.web.reactive.server.HttpHandlerConnector;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilderFactory;

class DefaultWebTestClientBuilder
implements WebTestClient.Builder {
    private final WebClient.Builder webClientBuilder = WebClient.builder();
    private final ClientHttpConnector connector;
    private Duration responseTimeout;

    public DefaultWebTestClientBuilder() {
        this((ClientHttpConnector)new ReactorClientHttpConnector());
    }

    public DefaultWebTestClientBuilder(HttpHandler httpHandler) {
        this(new HttpHandlerConnector(httpHandler));
    }

    public DefaultWebTestClientBuilder(ClientHttpConnector connector) {
        this.connector = connector;
    }

    @Override
    public WebTestClient.Builder baseUrl(String baseUrl) {
        this.webClientBuilder.baseUrl(baseUrl);
        return this;
    }

    @Override
    public WebTestClient.Builder uriBuilderFactory(UriBuilderFactory uriBuilderFactory) {
        this.webClientBuilder.uriBuilderFactory(uriBuilderFactory);
        return this;
    }

    @Override
    public WebTestClient.Builder defaultHeader(String headerName, String ... headerValues) {
        this.webClientBuilder.defaultHeader(headerName, headerValues);
        return this;
    }

    @Override
    public WebTestClient.Builder defaultCookie(String cookieName, String ... cookieValues) {
        this.webClientBuilder.defaultCookie(cookieName, cookieValues);
        return this;
    }

    @Override
    public WebTestClient.Builder exchangeStrategies(ExchangeStrategies strategies) {
        this.webClientBuilder.exchangeStrategies(strategies);
        return this;
    }

    @Override
    public WebTestClient.Builder responseTimeout(Duration timeout) {
        this.responseTimeout = timeout;
        return this;
    }

    @Override
    public WebTestClient build() {
        return new DefaultWebTestClient(this.webClientBuilder, this.connector, this.responseTimeout);
    }
}

