/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.FluxExchangeResult;
import org.springframework.test.web.reactive.server.HeaderAssertions;
import org.springframework.test.web.reactive.server.StatusAssertions;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WiretapConnector;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultWebTestClient
implements WebTestClient {
    private final WebClient webClient;
    private final WiretapConnector wiretapConnector;
    private final Duration timeout;
    private final AtomicLong requestIndex = new AtomicLong();

    DefaultWebTestClient(WebClient.Builder webClientBuilder, ClientHttpConnector connector, Duration timeout) {
        Assert.notNull((Object)webClientBuilder, (String)"WebClient.Builder is required");
        this.wiretapConnector = new WiretapConnector(connector);
        this.webClient = webClientBuilder.clientConnector((ClientHttpConnector)this.wiretapConnector).build();
        this.timeout = timeout != null ? timeout : Duration.ofSeconds(5L);
    }

    private DefaultWebTestClient(DefaultWebTestClient webTestClient, ExchangeFilterFunction filter) {
        this.webClient = webTestClient.webClient.filter(filter);
        this.timeout = webTestClient.timeout;
        this.wiretapConnector = webTestClient.wiretapConnector;
    }

    private Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public WebTestClient.UriSpec get() {
        return this.toUriSpec(WebClient::get);
    }

    @Override
    public WebTestClient.UriSpec head() {
        return this.toUriSpec(WebClient::head);
    }

    @Override
    public WebTestClient.UriSpec post() {
        return this.toUriSpec(WebClient::post);
    }

    @Override
    public WebTestClient.UriSpec put() {
        return this.toUriSpec(WebClient::put);
    }

    @Override
    public WebTestClient.UriSpec patch() {
        return this.toUriSpec(WebClient::patch);
    }

    @Override
    public WebTestClient.UriSpec delete() {
        return this.toUriSpec(WebClient::delete);
    }

    @Override
    public WebTestClient.UriSpec options() {
        return this.toUriSpec(WebClient::options);
    }

    private WebTestClient.UriSpec toUriSpec(Function<WebClient, WebClient.UriSpec> function) {
        return new DefaultUriSpec(function.apply(this.webClient));
    }

    @Override
    public WebTestClient filter(ExchangeFilterFunction filter) {
        return new DefaultWebTestClient(this, filter);
    }

    private class DefaultMapBodySpec
    implements WebTestClient.MapBodySpec {
        private final EntityExchangeResult<Map<?, ?>> result;

        public DefaultMapBodySpec(EntityExchangeResult<Map<?, ?>> result) {
            this.result = result;
        }

        private Map<?, ?> getBody() {
            return this.result.getResponseBody();
        }

        @Override
        public <K, V> EntityExchangeResult<Map<K, V>> isEqualTo(Map<K, V> expected) {
            String message = "Response body map";
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals(message, expected, this.getBody()));
            return this.returnResult();
        }

        @Override
        public WebTestClient.MapBodySpec hasSize(int size) {
            String message = "Response body map size";
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals(message, size, this.getBody().size()));
            return this;
        }

        @Override
        public WebTestClient.MapBodySpec contains(Object key, Object value) {
            String message = "Response body map value for key " + key;
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals(message, value, this.getBody().get(key)));
            return this;
        }

        @Override
        public WebTestClient.MapBodySpec containsKeys(Object ... keys) {
            List missing = Arrays.stream(keys).filter(k -> !this.getBody().containsKey(k)).collect(Collectors.toList());
            String message = "Response body map does not contain keys " + missing;
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, missing.isEmpty()));
            return this;
        }

        @Override
        public WebTestClient.MapBodySpec containsValues(Object ... values) {
            List missing = Arrays.stream(values).filter(v -> !this.getBody().containsValue(v)).collect(Collectors.toList());
            String message = "Response body map does not contain values " + missing;
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, missing.isEmpty()));
            return this;
        }

        @Override
        public <K, V> EntityExchangeResult<Map<K, V>> returnResult() {
            return new EntityExchangeResult<Map<K, V>>(this.result, this.getBody());
        }
    }

    private class DefaultBodySpec
    implements WebTestClient.BodySpec {
        private final UndecodedExchangeResult exchangeResult;

        public DefaultBodySpec(UndecodedExchangeResult result) {
            this.exchangeResult = result;
        }

        @Override
        public EntityExchangeResult<Void> isEmpty() {
            return this.exchangeResult.consumeEmpty();
        }

        @Override
        public WebTestClient.MapBodySpec map(Class<?> keyType, Class<?> valueType) {
            return this.map(ResolvableType.forClass(keyType), ResolvableType.forClass(valueType));
        }

        @Override
        public WebTestClient.MapBodySpec map(ResolvableType keyType, ResolvableType valueType) {
            return new DefaultMapBodySpec(this.exchangeResult.consumeMap(keyType, valueType));
        }
    }

    private class DefaultListBodySpec
    implements WebTestClient.ListBodySpec {
        private final EntityExchangeResult<List<?>> result;

        public DefaultListBodySpec(EntityExchangeResult<List<?>> result) {
            this.result = result;
        }

        @Override
        public <T> EntityExchangeResult<List<T>> isEqualTo(List<T> expected) {
            List<?> actual = this.result.getResponseBody();
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Response body", expected, actual));
            return this.returnResult();
        }

        @Override
        public WebTestClient.ListBodySpec hasSize(int size) {
            List<?> actual = this.result.getResponseBody();
            String message = "Response body does not contain " + size + " elements";
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals(message, size, actual.size()));
            return this;
        }

        @Override
        public WebTestClient.ListBodySpec contains(Object ... elements) {
            List<Object> expected = Arrays.asList(elements);
            List<?> actual = this.result.getResponseBody();
            String message = "Response body does not contain " + expected;
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, actual.containsAll(expected)));
            return this;
        }

        @Override
        public WebTestClient.ListBodySpec doesNotContain(Object ... elements) {
            List<Object> expected = Arrays.asList(elements);
            List<?> actual = this.result.getResponseBody();
            String message = "Response body should have contained " + expected;
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertTrue(message, !actual.containsAll(expected)));
            return this;
        }

        @Override
        public <T> EntityExchangeResult<List<T>> returnResult() {
            return new EntityExchangeResult<List<T>>(this.result, this.result.getResponseBody());
        }
    }

    private class DefaultSingleValueBodySpec
    implements WebTestClient.SingleValueBodySpec {
        private final EntityExchangeResult<?> result;

        public DefaultSingleValueBodySpec(EntityExchangeResult<?> result) {
            this.result = result;
        }

        @Override
        public <T> EntityExchangeResult<T> isEqualTo(T expected) {
            Object actual = this.result.getResponseBody();
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Response body", expected, actual));
            return this.returnResult();
        }

        @Override
        public <T> EntityExchangeResult<T> returnResult() {
            return new EntityExchangeResult(this.result, this.result.getResponseBody());
        }
    }

    private class DefaultTypeBodySpec
    implements WebTestClient.TypeBodySpec {
        private final UndecodedExchangeResult result;
        private final ResolvableType elementType;

        public DefaultTypeBodySpec(UndecodedExchangeResult result, ResolvableType elementType) {
            this.result = result;
            this.elementType = elementType;
        }

        @Override
        public WebTestClient.SingleValueBodySpec value() {
            return new DefaultSingleValueBodySpec(this.result.consumeSingle(this.elementType));
        }

        @Override
        public WebTestClient.ListBodySpec list() {
            return this.list(-1);
        }

        @Override
        public WebTestClient.ListBodySpec list(int count) {
            return new DefaultListBodySpec(this.result.consumeList(this.elementType, count));
        }

        @Override
        public <T> FluxExchangeResult<T> returnResult() {
            return this.result.decodeBody(this.elementType);
        }
    }

    private class DefaultResponseSpec
    implements WebTestClient.ResponseSpec {
        private final UndecodedExchangeResult result;

        public DefaultResponseSpec(ExchangeResult result, ClientResponse response) {
            this.result = new UndecodedExchangeResult(result, response);
        }

        @Override
        public StatusAssertions expectStatus() {
            return new StatusAssertions(this.result, this);
        }

        @Override
        public HeaderAssertions expectHeader() {
            return new HeaderAssertions(this.result, this);
        }

        @Override
        public WebTestClient.TypeBodySpec expectBody(Class<?> elementType) {
            return this.expectBody(ResolvableType.forClass(elementType));
        }

        @Override
        public WebTestClient.TypeBodySpec expectBody(ResolvableType elementType) {
            return new DefaultTypeBodySpec(this.result, elementType);
        }

        @Override
        public WebTestClient.BodySpec expectBody() {
            return new DefaultBodySpec(this.result);
        }

        @Override
        public WebTestClient.ResponseSpec consumeWith(Consumer<ExchangeResult> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result));
            return this;
        }

        @Override
        public ExchangeResult returnResult() {
            return this.result;
        }
    }

    private class UndecodedExchangeResult
    extends ExchangeResult {
        private final ClientResponse response;

        public UndecodedExchangeResult(ExchangeResult result, ClientResponse response) {
            super(result);
            this.response = response;
        }

        public EntityExchangeResult<?> consumeSingle(ResolvableType elementType) {
            Object body = ((Mono)this.response.body(BodyExtractors.toMono((ResolvableType)elementType))).block(DefaultWebTestClient.this.getTimeout());
            return new EntityExchangeResult<Object>(this, body);
        }

        public EntityExchangeResult<List<?>> consumeList(ResolvableType elementType, int count) {
            Flux flux = (Flux)this.response.body(BodyExtractors.toFlux((ResolvableType)elementType));
            if (count >= 0) {
                flux = flux.take((long)count);
            }
            List body = (List)flux.collectList().block(DefaultWebTestClient.this.getTimeout());
            return new EntityExchangeResult(this, body);
        }

        public <T> FluxExchangeResult<T> decodeBody(ResolvableType elementType) {
            Flux body = (Flux)this.response.body(BodyExtractors.toFlux((ResolvableType)elementType));
            return new FluxExchangeResult(this, body);
        }

        public EntityExchangeResult<Map<?, ?>> consumeMap(ResolvableType keyType, ResolvableType valueType) {
            ResolvableType mapType = ResolvableType.forClassWithGenerics(Map.class, (ResolvableType[])new ResolvableType[]{keyType, valueType});
            return this.consumeSingle(mapType);
        }

        public EntityExchangeResult<Void> consumeEmpty() {
            DataBuffer buffer = (DataBuffer)((Flux)this.response.body(BodyExtractors.toDataBuffers())).blockFirst(DefaultWebTestClient.this.getTimeout());
            this.assertWithDiagnostics(() -> AssertionErrors.assertTrue("Expected empty body", buffer == null));
            return new EntityExchangeResult<Object>(this, null);
        }
    }

    private class DefaultHeaderSpec
    implements WebTestClient.HeaderSpec {
        private final WebClient.HeaderSpec headerSpec;
        private final String requestId;

        DefaultHeaderSpec(WebClient.HeaderSpec spec) {
            this.headerSpec = spec;
            this.requestId = String.valueOf(DefaultWebTestClient.this.requestIndex.incrementAndGet());
            this.headerSpec.header("request-id", new String[]{this.requestId});
        }

        @Override
        public DefaultHeaderSpec header(String headerName, String ... headerValues) {
            this.headerSpec.header(headerName, headerValues);
            return this;
        }

        @Override
        public DefaultHeaderSpec headers(HttpHeaders headers) {
            this.headerSpec.headers(headers);
            return this;
        }

        @Override
        public DefaultHeaderSpec accept(MediaType ... acceptableMediaTypes) {
            this.headerSpec.accept(acceptableMediaTypes);
            return this;
        }

        @Override
        public DefaultHeaderSpec acceptCharset(Charset ... acceptableCharsets) {
            this.headerSpec.acceptCharset(acceptableCharsets);
            return this;
        }

        @Override
        public DefaultHeaderSpec contentType(MediaType contentType) {
            this.headerSpec.contentType(contentType);
            return this;
        }

        @Override
        public DefaultHeaderSpec contentLength(long contentLength) {
            this.headerSpec.contentLength(contentLength);
            return this;
        }

        @Override
        public DefaultHeaderSpec cookie(String name, String value) {
            this.headerSpec.cookie(name, value);
            return this;
        }

        @Override
        public DefaultHeaderSpec cookies(MultiValueMap<String, String> cookies) {
            this.headerSpec.cookies(cookies);
            return this;
        }

        @Override
        public DefaultHeaderSpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.headerSpec.ifModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public DefaultHeaderSpec ifNoneMatch(String ... ifNoneMatches) {
            this.headerSpec.ifNoneMatch(ifNoneMatches);
            return this;
        }

        @Override
        public WebTestClient.ResponseSpec exchange() {
            return this.toResponseSpec((Mono<ClientResponse>)this.headerSpec.exchange());
        }

        @Override
        public <T> WebTestClient.ResponseSpec exchange(BodyInserter<T, ? super ClientHttpRequest> inserter) {
            return this.toResponseSpec((Mono<ClientResponse>)this.headerSpec.exchange(inserter));
        }

        @Override
        public <T, S extends Publisher<T>> WebTestClient.ResponseSpec exchange(S publisher, Class<T> elementClass) {
            return this.toResponseSpec((Mono<ClientResponse>)this.headerSpec.exchange(publisher, elementClass));
        }

        private DefaultResponseSpec toResponseSpec(Mono<ClientResponse> mono) {
            ClientResponse clientResponse = (ClientResponse)mono.block(DefaultWebTestClient.this.getTimeout());
            ExchangeResult exchangeResult = DefaultWebTestClient.this.wiretapConnector.claimRequest(this.requestId);
            return new DefaultResponseSpec(exchangeResult, clientResponse);
        }
    }

    private class DefaultUriSpec
    implements WebTestClient.UriSpec {
        private final WebClient.UriSpec uriSpec;

        DefaultUriSpec(WebClient.UriSpec spec) {
            this.uriSpec = spec;
        }

        @Override
        public WebTestClient.HeaderSpec uri(URI uri) {
            return new DefaultHeaderSpec(this.uriSpec.uri(uri));
        }

        @Override
        public WebTestClient.HeaderSpec uri(String uriTemplate, Object ... uriVariables) {
            return new DefaultHeaderSpec(this.uriSpec.uri(uriTemplate, uriVariables));
        }

        @Override
        public WebTestClient.HeaderSpec uri(String uriTemplate, Map<String, ?> uriVariables) {
            return new DefaultHeaderSpec(this.uriSpec.uri(uriTemplate, uriVariables));
        }

        @Override
        public WebTestClient.HeaderSpec uri(Function<UriBuilder, URI> uriBuilder) {
            return new DefaultHeaderSpec(this.uriSpec.uri(uriBuilder));
        }
    }
}

