/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.Validator;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.config.CorsRegistry;
import org.springframework.web.reactive.config.DelegatingWebFluxConfiguration;
import org.springframework.web.reactive.config.PathMatchConfigurer;
import org.springframework.web.reactive.config.ViewResolverRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;

class DefaultControllerSpec
implements WebTestClient.ControllerSpec {
    private final List<Object> controllers;
    private final TestWebFluxConfigurer configurer = new TestWebFluxConfigurer();

    public DefaultControllerSpec(Object ... controllers) {
        Assert.isTrue((!ObjectUtils.isEmpty((Object[])controllers) ? 1 : 0) != 0, (String)"At least one controller is required");
        this.controllers = Arrays.asList(controllers);
    }

    @Override
    public DefaultControllerSpec contentTypeResolver(Consumer<RequestedContentTypeResolverBuilder> consumer) {
        this.configurer.contentTypeResolverConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec corsMappings(Consumer<CorsRegistry> consumer) {
        this.configurer.corsRegistryConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec pathMatching(Consumer<PathMatchConfigurer> consumer) {
        this.configurer.pathMatchConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec messageReaders(Consumer<List<HttpMessageReader<?>>> consumer) {
        this.configurer.readersConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec messageWriters(Consumer<List<HttpMessageWriter<?>>> consumer) {
        this.configurer.writersConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec formatters(Consumer<FormatterRegistry> consumer) {
        this.configurer.formattersConsumer = consumer;
        return this;
    }

    @Override
    public DefaultControllerSpec validator(Validator validator) {
        this.configurer.validator = validator;
        return this;
    }

    @Override
    public DefaultControllerSpec viewResolvers(Consumer<ViewResolverRegistry> consumer) {
        this.configurer.viewResolversConsumer = consumer;
        return this;
    }

    @Override
    public WebTestClient.Builder configureClient() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        this.controllers.forEach(controller -> this.registerBean(context, controller));
        context.register(new Class[]{DelegatingWebFluxConfiguration.class});
        context.registerBean(WebFluxConfigurer.class, () -> this.configurer, new BeanDefinitionCustomizer[0]);
        context.refresh();
        return WebTestClient.bindToApplicationContext((ApplicationContext)context);
    }

    private <T> void registerBean(AnnotationConfigApplicationContext context, T bean) {
        context.registerBean(bean.getClass(), () -> bean, new BeanDefinitionCustomizer[0]);
    }

    @Override
    public WebTestClient build() {
        return this.configureClient().build();
    }

    private class TestWebFluxConfigurer
    implements WebFluxConfigurer {
        private Consumer<RequestedContentTypeResolverBuilder> contentTypeResolverConsumer;
        private Consumer<CorsRegistry> corsRegistryConsumer;
        private Consumer<PathMatchConfigurer> pathMatchConsumer;
        private Consumer<List<HttpMessageReader<?>>> readersConsumer;
        private Consumer<List<HttpMessageWriter<?>>> writersConsumer;
        private Consumer<FormatterRegistry> formattersConsumer;
        private Validator validator;
        private Consumer<ViewResolverRegistry> viewResolversConsumer;

        private TestWebFluxConfigurer() {
        }

        public void configureContentTypeResolver(RequestedContentTypeResolverBuilder builder) {
            if (this.contentTypeResolverConsumer != null) {
                this.contentTypeResolverConsumer.accept(builder);
            }
        }

        public void addCorsMappings(CorsRegistry registry) {
            if (this.corsRegistryConsumer != null) {
                this.corsRegistryConsumer.accept(registry);
            }
        }

        public void configurePathMatching(PathMatchConfigurer configurer) {
            if (this.pathMatchConsumer != null) {
                this.pathMatchConsumer.accept(configurer);
            }
        }

        public void extendMessageReaders(List<HttpMessageReader<?>> readers) {
            if (this.readersConsumer != null) {
                this.readersConsumer.accept(readers);
            }
        }

        public void extendMessageWriters(List<HttpMessageWriter<?>> writers) {
            if (this.writersConsumer != null) {
                this.writersConsumer.accept(writers);
            }
        }

        public void addFormatters(FormatterRegistry registry) {
            if (this.formattersConsumer != null) {
                this.formattersConsumer.accept(registry);
            }
        }

        public Optional<Validator> getValidator() {
            return Optional.ofNullable(this.validator);
        }

        public void configureViewResolvers(ViewResolverRegistry registry) {
            if (this.viewResolversConsumer != null) {
                this.viewResolversConsumer.accept(registry);
            }
        }
    }
}

