/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.lang.reflect.Method;
import java.util.concurrent.TimeoutException;
import org.junit.runners.model.Statement;
import org.springframework.test.annotation.TestAnnotationUtils;
import org.springframework.util.Assert;

public class SpringFailOnTimeout
extends Statement {
    private final Statement next;
    private final long timeout;

    public SpringFailOnTimeout(Statement next, Method testMethod) {
        this(next, TestAnnotationUtils.getTimeout(testMethod));
    }

    public SpringFailOnTimeout(Statement next, long timeout) {
        Assert.notNull((Object)next, (String)"next statement must not be null");
        Assert.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.next = next;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void evaluate() throws Throwable {
        if (this.timeout == 0L) {
            this.next.evaluate();
            return;
        } else {
            long startTime = System.currentTimeMillis();
            try {
                this.next.evaluate();
            }
            catch (Throwable throwable) {
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed <= this.timeout) throw throwable;
                throw new TimeoutException(String.format("Test took %s ms; limit was %s ms.", elapsed, this.timeout));
            }
            long elapsed = System.currentTimeMillis() - startTime;
            if (elapsed <= this.timeout) return;
            throw new TimeoutException(String.format("Test took %s ms; limit was %s ms.", elapsed, this.timeout));
        }
    }
}

