/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.runners.TestClass;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.annotation.ProfileValueSource;
import org.springframework.test.annotation.ProfileValueUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpringTestMethod {
    private static final Log logger = LogFactory.getLog(SpringTestMethod.class);
    private final Method method;
    private final ProfileValueSource profileValueSource;
    private final TestClass testClass;

    public SpringTestMethod(Method method, TestClass testClass) {
        this.method = method;
        this.testClass = testClass;
        this.profileValueSource = ProfileValueUtils.retrieveProfileValueSource(testClass.getJavaClass());
    }

    public boolean expectsException() {
        return this.getExpectedException() != null;
    }

    public List<Method> getAfters() {
        return this.getTestClass().getAnnotatedMethods(After.class);
    }

    public List<Method> getBefores() {
        return this.getTestClass().getAnnotatedMethods(Before.class);
    }

    public Class<? extends Throwable> getExpectedException() throws IllegalStateException {
        Class junitExpectedException;
        ExpectedException expectedExAnn = this.getMethod().getAnnotation(ExpectedException.class);
        Test testAnnotation = this.getMethod().getAnnotation(Test.class);
        Class expectedException = null;
        Class springExpectedException = expectedExAnn != null && expectedExAnn.value() != null ? expectedExAnn.value() : null;
        Class clazz = junitExpectedException = testAnnotation != null && testAnnotation.expected() != Test.None.class ? testAnnotation.expected() : null;
        if (springExpectedException != null && junitExpectedException != null) {
            String msg = "Test method [" + this.getMethod() + "] has been configured with Spring's @ExpectedException(" + springExpectedException.getName() + ".class) and JUnit's @Test(expected=" + junitExpectedException.getName() + ".class) annotations. " + "Only one declaration of an 'expected exception' is permitted per test method.";
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        if (springExpectedException != null) {
            expectedException = springExpectedException;
        } else if (junitExpectedException != null) {
            expectedException = junitExpectedException;
        }
        return expectedException;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final TestClass getTestClass() {
        return this.testClass;
    }

    public long getTimeout() {
        Test testAnnotation = this.getMethod().getAnnotation(Test.class);
        return testAnnotation != null && testAnnotation.timeout() > 0L ? testAnnotation.timeout() : 0L;
    }

    public void invoke(Object testInstance) throws IllegalAccessException, InvocationTargetException {
        this.getMethod().invoke(testInstance, new Object[0]);
    }

    public boolean isIgnored() {
        return this.getMethod().isAnnotationPresent(Ignore.class) || !ProfileValueUtils.isTestEnabledInThisEnvironment(this.profileValueSource, this.method, this.testClass.getJavaClass());
    }

    public boolean isUnexpected(Throwable exception) {
        return !this.getExpectedException().isAssignableFrom(exception.getClass());
    }
}

