/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.NotTransactional;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.transaction.AfterTransaction;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.test.context.transaction.TransactionConfigurationAttributes;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(TransactionalTestExecutionListener.class);
    protected final TransactionAttributeSource transactionAttributeSource = new AnnotationTransactionAttributeSource();
    protected TransactionDefinition transactionDefinition;
    private PlatformTransactionManager transactionManager = null;
    private int transactionsStarted = 0;
    protected TransactionStatus transactionStatus;
    private boolean transactionFlaggedForCommit = false;

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.transactionDefinition = null;
        Method testMethod = testContext.getTestMethod();
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null.");
        if (testMethod.isAnnotationPresent(NotTransactional.class)) {
            this.transactionStatus = null;
            return;
        }
        TransactionAttribute explicitTransactionDefinition = this.transactionAttributeSource.getTransactionAttribute(testMethod, testContext.getTestClass());
        if (explicitTransactionDefinition != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Explicit transaction definition [" + explicitTransactionDefinition + "] found for test context [" + (Object)((Object)testContext) + "]."));
            }
            this.transactionDefinition = explicitTransactionDefinition;
        }
        if (this.transactionDefinition != null) {
            if (this.getTransactionManager(testContext) == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Transaction definition was set for test context [" + (Object)((Object)testContext) + "], but no transaction manager was set: test will NOT run within a transaction."));
                }
            } else {
                this.runBeforeTransactionMethods(testContext);
                this.startNewTransaction(testContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        Assert.notNull((Object)testContext.getTestMethod(), (String)"The test method of the supplied TestContext must not be null.");
        if (this.transactionStatus != null && !this.transactionStatus.isCompleted()) {
            try {
                this.endTransaction(testContext);
            }
            finally {
                this.runAfterTransactionMethods(testContext);
            }
        }
    }

    protected void runBeforeTransactionMethods(TestContext testContext) throws Exception {
        try {
            List<Method> methods = this.getAnnotatedMethods(testContext.getTestClass(), BeforeTransaction.class);
            Collections.reverse(methods);
            for (Method method : methods) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing @BeforeTransaction method [" + method + "] for test context [" + (Object)((Object)testContext) + "]."));
                }
                method.invoke(testContext.getTestInstance(), new Object[0]);
            }
        }
        catch (InvocationTargetException ex) {
            logger.error((Object)("Exception encountered while executing @BeforeTransaction methods for test context [" + (Object)((Object)testContext) + "]."), ex.getTargetException());
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
        }
    }

    protected void runAfterTransactionMethods(TestContext testContext) throws Exception {
        Throwable afterTransactionException = null;
        List<Method> methods = this.getAnnotatedMethods(testContext.getTestClass(), AfterTransaction.class);
        for (Method method : methods) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing @AfterTransaction method [" + method + "] for test context [" + (Object)((Object)testContext) + "]."));
                }
                method.invoke(testContext.getTestInstance(), new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (afterTransactionException == null) {
                    afterTransactionException = targetException;
                }
                logger.error((Object)("Exception encountered while executing @AfterTransaction method [" + method + "] for test context [" + (Object)((Object)testContext) + "]."), targetException);
            }
            catch (Exception ex) {
                if (afterTransactionException == null) {
                    afterTransactionException = ex;
                }
                logger.error((Object)("Exception encountered while executing @AfterTransaction method [" + method + "] for test context [" + (Object)((Object)testContext) + "]."), (Throwable)ex);
            }
        }
        if (afterTransactionException != null) {
            ReflectionUtils.rethrowException(afterTransactionException);
        }
    }

    protected void startNewTransaction(TestContext testContext) throws TransactionException, Exception {
        if (this.transactionStatus != null) {
            throw new IllegalStateException("Cannot start new transaction without ending existing transaction: Invoke endTransaction() before startNewTransaction().");
        }
        PlatformTransactionManager transactionManager = this.getTransactionManager(testContext);
        if (transactionManager == null) {
            throw new IllegalStateException("No transaction manager set for test context [" + (Object)((Object)testContext) + "].");
        }
        this.transactionStatus = transactionManager.getTransaction(this.transactionDefinition);
        ++this.transactionsStarted;
        boolean bl = this.transactionFlaggedForCommit = !this.isRollback(testContext);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Began transaction (" + this.transactionsStarted + "): transaction manager [" + transactionManager + "]; rollback [" + this.isRollback(testContext) + "]; flagged for commmit [" + this.transactionFlaggedForCommit + "]."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction(TestContext testContext) throws TransactionException, Exception {
        boolean commit;
        boolean bl = commit = this.isTransactionFlaggedForCommit(testContext) || !this.isRollback(testContext);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Ending transaction for test context [" + (Object)((Object)testContext) + "]; transactionStatus [" + this.transactionStatus + "]; commit [" + commit + "]."));
        }
        if (this.transactionStatus != null) {
            try {
                if (commit) {
                    this.getTransactionManager(testContext).commit(this.transactionStatus);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Committed transaction after test execution for test context [" + (Object)((Object)testContext) + "]."));
                    }
                } else {
                    this.getTransactionManager(testContext).rollback(this.transactionStatus);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Rolled back transaction after test execution for test context [" + (Object)((Object)testContext) + "]."));
                    }
                }
            }
            finally {
                this.transactionStatus = null;
            }
        }
    }

    protected final PlatformTransactionManager getTransactionManager(TestContext testContext) throws Exception {
        if (this.transactionManager != null) {
            return this.transactionManager;
        }
        TransactionConfigurationAttributes configAttributes = this.retrieveTransactionConfigurationAttributes(testContext.getTestClass());
        String transactionManagerName = configAttributes.getTransactionManagerName();
        try {
            this.transactionManager = (PlatformTransactionManager)testContext.getApplicationContext().getBean(transactionManagerName, PlatformTransactionManager.class);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Caught exception while retrieving transaction manager with bean name [" + transactionManagerName + "] for test context [" + (Object)((Object)testContext) + "]."), (Throwable)e);
            }
            throw e;
        }
        return this.transactionManager;
    }

    protected final boolean isDefaultRollback(TestContext testContext) throws Exception {
        return this.retrieveTransactionConfigurationAttributes(testContext.getTestClass()).isDefaultRollback();
    }

    protected final boolean isRollback(TestContext testContext) throws Exception {
        boolean rollback = this.isDefaultRollback(testContext);
        Rollback rollbackAnnotation = testContext.getTestMethod().getAnnotation(Rollback.class);
        if (rollbackAnnotation != null) {
            boolean rollbackOverride = rollbackAnnotation.value();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Method-level @Rollback(" + rollbackOverride + ") overrides default rollback [" + rollback + "] for test context [" + (Object)((Object)testContext) + "]."));
            }
            rollback = rollbackOverride;
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No method-level @Rollback override: using default rollback [" + rollback + "] for test context [" + (Object)((Object)testContext) + "]."));
        }
        return rollback;
    }

    protected final boolean isTransactionFlaggedForCommit(TestContext testContext) {
        return this.transactionFlaggedForCommit;
    }

    protected final void flagTransactionForCommit(TestContext testContext) throws IllegalStateException {
        try {
            if (this.getTransactionManager(testContext) == null) {
                throw new IllegalStateException("No transaction manager set.");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("No transaction manager set.", e);
        }
        this.transactionFlaggedForCommit = true;
    }

    private List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList results = new ArrayList();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            results.add(current);
        }
        return results;
    }

    private List<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationType) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (Class<?> eachClass : this.getSuperClasses(clazz)) {
            Method[] methods;
            for (Method eachMethod : methods = eachClass.getDeclaredMethods()) {
                Annotation annotation = eachMethod.getAnnotation(annotationType);
                if (annotation == null || this.isShadowed(eachMethod, results)) continue;
                results.add(eachMethod);
            }
        }
        return results;
    }

    private boolean isShadowed(Method method, List<Method> previousMethods) {
        for (Method each : previousMethods) {
            if (!this.isShadowed(method, each)) continue;
            return true;
        }
        return false;
    }

    private boolean isShadowed(Method current, Method previous) {
        if (!previous.getName().equals(current.getName())) {
            return false;
        }
        if (previous.getParameterTypes().length != current.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < previous.getParameterTypes().length; ++i) {
            if (previous.getParameterTypes()[i].equals(current.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    private TransactionConfigurationAttributes retrieveTransactionConfigurationAttributes(Class<?> clazz) {
        boolean defaultRollback;
        String transactionManagerName;
        Assert.notNull(clazz, (String)"Can not retrieve transaction configuration attributes for a NULL class.");
        Class<TransactionConfiguration> annotationType = TransactionConfiguration.class;
        TransactionConfiguration config = clazz.getAnnotation(annotationType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved @TransactionConfiguration [" + config + "] for test class [" + clazz + "]."));
        }
        if (config != null) {
            transactionManagerName = config.transactionManager();
            defaultRollback = config.defaultRollback();
        } else {
            transactionManagerName = (String)AnnotationUtils.getDefaultValue(annotationType, (String)"transactionManager");
            defaultRollback = (Boolean)AnnotationUtils.getDefaultValue(annotationType, (String)"defaultRollback");
        }
        TransactionConfigurationAttributes configAttributes = new TransactionConfigurationAttributes(transactionManagerName, defaultRollback);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved TransactionConfigurationAttributes [" + configAttributes + "] for class [" + clazz + "]."));
        }
        return configAttributes;
    }
}

