/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.server.MvcResult;
import org.springframework.test.web.server.ResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashAttributeResultMatchers {
    protected FlashAttributeResultMatchers() {
    }

    public <T> ResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                MatcherAssert.assertThat((String)"Flash attribute", (Object)result.getFlashMap().get((Object)name), (Matcher)matcher);
            }
        };
    }

    public <T> ResultMatcher attribute(String name, Object value) {
        return this.attribute(name, Matchers.equalTo((Object)value));
    }

    public <T> ResultMatcher attributeExists(final String ... names) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                for (String name : names) {
                    FlashAttributeResultMatchers.this.attribute(name, Matchers.notNullValue()).match(result);
                }
            }
        };
    }

    public <T> ResultMatcher attributeCount(final int count) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("FlashMap size", count, result.getFlashMap().size());
            }
        };
    }
}

