/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.result;

import javax.xml.transform.Source;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.http.MediaType;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.server.MvcResult;
import org.springframework.test.web.server.ResultMatcher;
import org.springframework.test.web.support.XmlExpectationsHelper;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentResultMatchers {
    private final XmlExpectationsHelper xmlHelper = new XmlExpectationsHelper();

    protected ContentResultMatchers() {
    }

    public ResultMatcher mimeType(String contentType) {
        return this.mimeType(MediaType.parseMediaType((String)contentType));
    }

    public ResultMatcher mimeType(final MediaType contentType) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String actual = result.getResponse().getContentType();
                AssertionErrors.assertTrue("Content type not set", actual != null);
                AssertionErrors.assertEquals("Content type", contentType, MediaType.parseMediaType((String)actual));
            }
        };
    }

    public ResultMatcher encoding(final String characterEncoding) {
        return new ResultMatcher(){

            public void match(MvcResult result) {
                String actual = result.getResponse().getCharacterEncoding();
                AssertionErrors.assertEquals("Character encoding", characterEncoding, actual);
            }
        };
    }

    public ResultMatcher string(final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                MatcherAssert.assertThat((String)"Response content", (Object)result.getResponse().getContentAsString(), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher string(String content) {
        return this.string((Matcher<? super String>)Matchers.equalTo((Object)content));
    }

    public ResultMatcher bytes(final byte[] expectedContent) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                byte[] content = result.getResponse().getContentAsByteArray();
                MatcherAssert.assertThat((String)"Response content", (Object)content, (Matcher)Matchers.equalTo((Object)expectedContent));
            }
        };
    }

    public ResultMatcher xml(final String xmlContent) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                ContentResultMatchers.this.xmlHelper.assertXmlEqual(xmlContent, content);
            }
        };
    }

    public ResultMatcher node(final Matcher<? super Node> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                ContentResultMatchers.this.xmlHelper.assertNode(content, (Matcher<? super Node>)matcher);
            }
        };
    }

    public ResultMatcher source(final Matcher<? super Source> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                ContentResultMatchers.this.xmlHelper.assertSource(content, (Matcher<? super Source>)matcher);
            }
        };
    }
}

