/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.request;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.Mergeable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.web.server.RequestBuilder;
import org.springframework.test.web.server.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.support.SessionFlashMapManager;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpServletRequestBuilder
implements RequestBuilder,
Mergeable {
    private final UriComponentsBuilder uriComponentsBuilder;
    private final HttpMethod method;
    private final MultiValueMap<String, Object> headers = new LinkedMultiValueMap();
    private String contentType;
    private byte[] content;
    private final MultiValueMap<String, String> parameters = new LinkedMultiValueMap();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private Locale locale;
    private String characterEncoding;
    private Principal principal;
    private Boolean secure;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private MockHttpSession session;
    private final Map<String, Object> sessionAttributes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> flashAttributes = new LinkedHashMap<String, Object>();
    private String contextPath = "";
    private String servletPath = "";
    private String pathInfo = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n";
    private final List<RequestPostProcessor> postProcessors = new ArrayList<RequestPostProcessor>();

    MockHttpServletRequestBuilder(URI uri, HttpMethod httpMethod) {
        Assert.notNull((Object)uri, (String)"uri is required");
        Assert.notNull((Object)httpMethod, (String)"httpMethod is required");
        this.uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)uri);
        this.method = httpMethod;
    }

    public MockHttpServletRequestBuilder param(String name, String ... values) {
        MockHttpServletRequestBuilder.addToMultiValueMap(this.parameters, name, values);
        return this;
    }

    public MockHttpServletRequestBuilder header(String name, Object ... values) {
        MockHttpServletRequestBuilder.addToMultiValueMap(this.headers, name, values);
        return this;
    }

    public MockHttpServletRequestBuilder headers(HttpHeaders httpHeaders) {
        for (String name : httpHeaders.keySet()) {
            Object[] values = ObjectUtils.toObjectArray((Object)httpHeaders.get((Object)name).toArray());
            MockHttpServletRequestBuilder.addToMultiValueMap(this.headers, name, values);
        }
        return this;
    }

    public MockHttpServletRequestBuilder contentType(MediaType mediaType) {
        Assert.notNull((Object)mediaType, (String)"'contentType' must not be null");
        this.contentType = mediaType.toString();
        this.headers.set((Object)"Content-Type", (Object)this.contentType);
        return this;
    }

    public MockHttpServletRequestBuilder accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"No 'Accept' media types");
        this.headers.set((Object)"Accept", (Object)MediaType.toString(Arrays.asList(mediaTypes)));
        return this;
    }

    public MockHttpServletRequestBuilder body(byte[] content) {
        this.content = content;
        return this;
    }

    public MockHttpServletRequestBuilder cookie(Cookie ... cookies) {
        Assert.notNull((Object)cookies, (String)"'cookies' must not be null");
        Assert.notEmpty((Object[])cookies, (String)"'cookies' must not be empty");
        this.cookies.addAll(Arrays.asList(cookies));
        return this;
    }

    public MockHttpServletRequestBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public MockHttpServletRequestBuilder characterEncoding(String encoding) {
        this.characterEncoding = encoding;
        return this;
    }

    public MockHttpServletRequestBuilder requestAttr(String name, Object value) {
        MockHttpServletRequestBuilder.addAttributeToMap(this.attributes, name, value);
        return this;
    }

    public MockHttpServletRequestBuilder sessionAttr(String name, Object value) {
        MockHttpServletRequestBuilder.addAttributeToMap(this.sessionAttributes, name, value);
        return this;
    }

    public MockHttpServletRequestBuilder sessionAttrs(Map<String, Object> sessionAttributes) {
        Assert.notEmpty(sessionAttributes, (String)"'sessionAttrs' must not be empty");
        for (String name : sessionAttributes.keySet()) {
            this.sessionAttr(name, sessionAttributes.get(name));
        }
        return this;
    }

    public MockHttpServletRequestBuilder flashAttr(String name, Object value) {
        MockHttpServletRequestBuilder.addAttributeToMap(this.flashAttributes, name, value);
        return this;
    }

    public MockHttpServletRequestBuilder flashAttrs(Map<String, Object> flashAttributes) {
        Assert.notEmpty(flashAttributes, (String)"'flashAttrs' must not be empty");
        for (String name : flashAttributes.keySet()) {
            this.flashAttr(name, flashAttributes.get(name));
        }
        return this;
    }

    public MockHttpServletRequestBuilder session(MockHttpSession session) {
        Assert.notNull((Object)session, (String)"'session' must not be null");
        this.session = session;
        return this;
    }

    public MockHttpServletRequestBuilder principal(Principal principal) {
        Assert.notNull((Object)principal, (String)"'principal' must not be null");
        this.principal = principal;
        return this;
    }

    public MockHttpServletRequestBuilder contextPath(String contextPath) {
        if (StringUtils.hasText((String)contextPath)) {
            Assert.isTrue((boolean)contextPath.startsWith("/"), (String)"Context path must start with a '/'");
            Assert.isTrue((!contextPath.endsWith("/") ? 1 : 0) != 0, (String)"Context path must not end with a '/'");
        }
        this.contextPath = contextPath != null ? contextPath : "";
        return this;
    }

    public MockHttpServletRequestBuilder servletPath(String servletPath) {
        if (StringUtils.hasText((String)servletPath)) {
            Assert.isTrue((boolean)servletPath.startsWith("/"), (String)"Servlet path must start with a '/'");
            Assert.isTrue((!servletPath.endsWith("/") ? 1 : 0) != 0, (String)"Servlet path must not end with a '/'");
        }
        this.servletPath = servletPath != null ? servletPath : "";
        return this;
    }

    public MockHttpServletRequestBuilder pathInfo(String pathInfo) {
        if (StringUtils.hasText((String)pathInfo)) {
            Assert.isTrue((boolean)pathInfo.startsWith("/"), (String)"pathInfo must start with a '/'");
        }
        this.pathInfo = pathInfo;
        return this;
    }

    public MockHttpServletRequestBuilder secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public MockHttpServletRequestBuilder with(RequestPostProcessor postProcessor) {
        Assert.notNull((Object)postProcessor, (String)"postProcessor is required");
        this.postProcessors.add(postProcessor);
        return this;
    }

    public boolean isMergeEnabled() {
        return true;
    }

    public Object merge(Object parent) {
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof MockHttpServletRequestBuilder)) {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        MockHttpServletRequestBuilder parentBuilder = (MockHttpServletRequestBuilder)parent;
        for (String headerName : parentBuilder.headers.keySet()) {
            if (this.headers.containsKey((Object)headerName)) continue;
            this.headers.put((Object)headerName, parentBuilder.headers.get((Object)headerName));
        }
        if (this.contentType == null) {
            this.contentType = parentBuilder.contentType;
        }
        if (this.content == null) {
            this.content = parentBuilder.content;
        }
        for (String paramName : parentBuilder.parameters.keySet()) {
            if (this.parameters.containsKey((Object)paramName)) continue;
            this.parameters.put((Object)paramName, parentBuilder.parameters.get((Object)paramName));
        }
        for (Cookie cookie : parentBuilder.cookies) {
            if (this.containsCookie(cookie)) continue;
            this.cookies.add(cookie);
        }
        if (this.locale == null) {
            this.locale = parentBuilder.locale;
        }
        if (this.characterEncoding == null) {
            this.characterEncoding = parentBuilder.characterEncoding;
        }
        if (this.principal == null) {
            this.principal = parentBuilder.principal;
        }
        if (this.secure == null) {
            this.secure = parentBuilder.secure;
        }
        for (String attributeName : parentBuilder.attributes.keySet()) {
            if (this.attributes.containsKey(attributeName)) continue;
            this.attributes.put(attributeName, parentBuilder.attributes.get(attributeName));
        }
        if (this.session == null) {
            this.session = parentBuilder.session;
        }
        for (String sessionAttributeName : parentBuilder.sessionAttributes.keySet()) {
            if (this.sessionAttributes.containsKey(sessionAttributeName)) continue;
            this.sessionAttributes.put(sessionAttributeName, parentBuilder.sessionAttributes.get(sessionAttributeName));
        }
        for (String flashAttributeName : parentBuilder.flashAttributes.keySet()) {
            if (this.flashAttributes.containsKey(flashAttributeName)) continue;
            this.flashAttributes.put(flashAttributeName, parentBuilder.flashAttributes.get(flashAttributeName));
        }
        if (!StringUtils.hasText((String)this.contextPath)) {
            this.contextPath = parentBuilder.contextPath;
        }
        if (!StringUtils.hasText((String)this.servletPath)) {
            this.servletPath = parentBuilder.servletPath;
        }
        if ("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(this.pathInfo)) {
            this.pathInfo = parentBuilder.pathInfo;
        }
        this.postProcessors.addAll(parentBuilder.postProcessors);
        return this;
    }

    private boolean containsCookie(Cookie cookie) {
        for (Cookie c : this.cookies) {
            if (!ObjectUtils.nullSafeEquals((Object)c.getName(), (Object)cookie.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final MockHttpServletRequest buildRequest(ServletContext servletContext) {
        MockHttpServletRequest request = this.createServletRequest(servletContext);
        UriComponents uriComponents = this.uriComponentsBuilder.build();
        String requestUri = uriComponents.getPath();
        request.setRequestURI(requestUri);
        this.updatePathRequestProperties(request, requestUri);
        if (uriComponents.getScheme() != null) {
            request.setScheme(uriComponents.getScheme());
        }
        if (uriComponents.getHost() != null) {
            request.setServerName(uriComponents.getHost());
        }
        if (uriComponents.getPort() != -1) {
            request.setServerPort(uriComponents.getPort());
        }
        request.setMethod(this.method.name());
        for (String name : this.headers.keySet()) {
            for (Object value : (List)this.headers.get((Object)name)) {
                request.addHeader(name, value);
            }
        }
        request.setQueryString(uriComponents.getQuery());
        for (Map.Entry entry : uriComponents.getQueryParams().entrySet()) {
            for (Object value : (List)entry.getValue()) {
                request.addParameter((String)entry.getKey(), value);
            }
        }
        for (String name : this.parameters.keySet()) {
            for (Object value : (List)this.parameters.get((Object)name)) {
                request.addParameter(name, value);
            }
        }
        request.setContentType(this.contentType);
        request.setContent(this.content);
        request.setCookies(this.cookies.toArray(new Cookie[this.cookies.size()]));
        if (this.locale != null) {
            request.addPreferredLocale(this.locale);
        }
        request.setCharacterEncoding(this.characterEncoding);
        request.setUserPrincipal(this.principal);
        if (this.secure != null) {
            request.setSecure(this.secure.booleanValue());
        }
        for (String name : this.attributes.keySet()) {
            request.setAttribute(name, this.attributes.get(name));
        }
        if (this.session != null) {
            request.setSession((HttpSession)this.session);
        }
        for (String name : this.sessionAttributes.keySet()) {
            request.getSession().setAttribute(name, this.sessionAttributes.get(name));
        }
        FlashMap flashMap = new FlashMap();
        flashMap.putAll(this.flashAttributes);
        FlashMapManager flashMapManager = this.getFlashMapManager(request);
        flashMapManager.saveOutputFlashMap(flashMap, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        for (RequestPostProcessor postProcessor : this.postProcessors) {
            request = postProcessor.postProcessRequest(request);
            Assert.notNull((Object)request, (String)("Post-processor [" + postProcessor.getClass().getName() + "] returned null"));
        }
        return request;
    }

    protected MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        return new MockHttpServletRequest(servletContext);
    }

    private void updatePathRequestProperties(MockHttpServletRequest request, String requestUri) {
        Assert.isTrue((boolean)requestUri.startsWith(this.contextPath), (String)("requestURI [" + requestUri + "] does not start with contextPath [" + this.contextPath + "]"));
        request.setContextPath(this.contextPath);
        request.setServletPath(this.servletPath);
        if ("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(this.pathInfo)) {
            Assert.isTrue((boolean)requestUri.startsWith(this.contextPath + this.servletPath), (String)("Invalid servletPath [" + this.servletPath + "] for requestURI [" + requestUri + "]"));
            String extraPath = requestUri.substring(this.contextPath.length() + this.servletPath.length());
            this.pathInfo = StringUtils.hasText((String)extraPath) ? extraPath : null;
        }
        request.setPathInfo(this.pathInfo);
    }

    private FlashMapManager getFlashMapManager(MockHttpServletRequest request) {
        SessionFlashMapManager flashMapManager = null;
        try {
            ServletContext servletContext = request.getServletContext();
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            flashMapManager = (FlashMapManager)wac.getBean("flashMapManager", FlashMapManager.class);
        }
        catch (IllegalStateException ex) {
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return flashMapManager != null ? flashMapManager : new SessionFlashMapManager();
    }

    private static <T> void addToMultiValueMap(MultiValueMap<String, T> map, String name, T[] values) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull(values, (String)"'values' is required");
        Assert.notEmpty((Object[])values, (String)"'values' must not be empty");
        for (T value : values) {
            map.add((Object)name, value);
        }
    }

    private static void addAttributeToMap(Map<String, Object> map, String name, Object value) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        map.put(name, value);
    }
}

