/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.response;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.test.web.client.response.DefaultResponseCreator;

public abstract class ResponseCreators {
    private ResponseCreators() {
    }

    public static DefaultResponseCreator withSuccess() {
        return new DefaultResponseCreator(HttpStatus.OK);
    }

    public static DefaultResponseCreator withSuccess(String body, MediaType mediaType) {
        return new DefaultResponseCreator(HttpStatus.OK).body(body).contentType(mediaType);
    }

    public static DefaultResponseCreator withSuccess(byte[] body, MediaType contentType) {
        return new DefaultResponseCreator(HttpStatus.OK).body(body).contentType(contentType);
    }

    public static DefaultResponseCreator withSuccess(Resource body, MediaType contentType) {
        return new DefaultResponseCreator(HttpStatus.OK).body(body).contentType(contentType);
    }

    public static DefaultResponseCreator withCreatedEntity(URI location) {
        return new DefaultResponseCreator(HttpStatus.CREATED).location(location);
    }

    public static DefaultResponseCreator withNoContent() {
        return new DefaultResponseCreator(HttpStatus.NO_CONTENT);
    }

    public static DefaultResponseCreator withBadRequest() {
        return new DefaultResponseCreator(HttpStatus.BAD_REQUEST);
    }

    public static DefaultResponseCreator withUnauthorizedRequest() {
        return new DefaultResponseCreator(HttpStatus.UNAUTHORIZED);
    }

    public static DefaultResponseCreator withServerError() {
        return new DefaultResponseCreator(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static DefaultResponseCreator withStatus(HttpStatus status) {
        return new DefaultResponseCreator(status);
    }

    public static ResponseCreator withResponse(final String body, final HttpHeaders headers, final HttpStatus statusCode, String statusText) {
        return new ResponseCreator(){

            public MockClientHttpResponse createResponse(ClientHttpRequest request) throws IOException {
                MockClientHttpResponse response = new MockClientHttpResponse(body.getBytes("UTF-8"), statusCode);
                response.getHeaders().putAll((Map)headers);
                return response;
            }
        };
    }

    public static ResponseCreator withResponse(String body, HttpHeaders headers) {
        return ResponseCreators.withResponse(body, headers, HttpStatus.OK, "");
    }

    public static ResponseCreator withResponse(final Resource body, final HttpHeaders headers, final HttpStatus statusCode, String statusText) {
        return new ResponseCreator(){

            public MockClientHttpResponse createResponse(ClientHttpRequest request) throws IOException {
                MockClientHttpResponse response = new MockClientHttpResponse(body.getInputStream(), statusCode);
                response.getHeaders().putAll((Map)headers);
                return response;
            }
        };
    }

    public static ResponseCreator withResponse(Resource body, HttpHeaders headers) {
        return ResponseCreators.withResponse(body, headers, HttpStatus.OK, "");
    }
}

