/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Parameters;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.Wrapped;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.connection.ConnectionFactoryUtils;
import org.springframework.r2dbc.core.ColumnMapRowMapper;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.DefaultFetchSpec;
import org.springframework.r2dbc.core.DelegateConnectionFunction;
import org.springframework.r2dbc.core.ExecuteFunction;
import org.springframework.r2dbc.core.FetchSpec;
import org.springframework.r2dbc.core.MapBindParameterSource;
import org.springframework.r2dbc.core.NamedParameterExpander;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.ResultFunction;
import org.springframework.r2dbc.core.SqlProvider;
import org.springframework.r2dbc.core.StatementFilterFunction;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;
import org.springframework.r2dbc.core.binding.BindTarget;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultDatabaseClient
implements DatabaseClient {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final BindMarkersFactory bindMarkersFactory;
    private final ConnectionFactory connectionFactory;
    private final ExecuteFunction executeFunction;
    @Nullable
    private final NamedParameterExpander namedParameterExpander;

    DefaultDatabaseClient(BindMarkersFactory bindMarkersFactory, ConnectionFactory connectionFactory, ExecuteFunction executeFunction, boolean namedParameters) {
        this.bindMarkersFactory = bindMarkersFactory;
        this.connectionFactory = connectionFactory;
        this.executeFunction = executeFunction;
        this.namedParameterExpander = namedParameters ? new NamedParameterExpander() : null;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public DatabaseClient.GenericExecuteSpec sql(String sql) {
        Assert.hasText((String)sql, (String)"SQL must not be null or empty");
        return this.sql(() -> sql);
    }

    @Override
    public DatabaseClient.GenericExecuteSpec sql(Supplier<String> sqlSupplier) {
        Assert.notNull(sqlSupplier, (String)"SQL Supplier must not be null");
        return new DefaultGenericExecuteSpec(sqlSupplier);
    }

    @Override
    public <T> Mono<T> inConnection(Function<Connection, Mono<T>> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Mono connectionMono = this.getConnection().map(connection -> new ConnectionCloseHolder((Connection)connection, this::closeConnection));
        return Mono.usingWhen((Publisher)connectionMono, connectionCloseHolder -> {
            Connection connectionToUse = DefaultDatabaseClient.createConnectionProxy(connectionCloseHolder.connection);
            try {
                return (Mono)action.apply(connectionToUse);
            }
            catch (R2dbcException ex) {
                String sql = DefaultDatabaseClient.getSql(action);
                return Mono.error((Throwable)ConnectionFactoryUtils.convertR2dbcException("doInConnection", sql, ex));
            }
        }, ConnectionCloseHolder::close, (it, err) -> it.close(), ConnectionCloseHolder::close).onErrorMap(R2dbcException.class, ex -> ConnectionFactoryUtils.convertR2dbcException("execute", DefaultDatabaseClient.getSql(action), ex));
    }

    @Override
    public <T> Flux<T> inConnectionMany(Function<Connection, Flux<T>> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Mono connectionMono = this.getConnection().map(connection -> new ConnectionCloseHolder((Connection)connection, this::closeConnection));
        return Flux.usingWhen((Publisher)connectionMono, connectionCloseHolder -> {
            Connection connectionToUse = DefaultDatabaseClient.createConnectionProxy(connectionCloseHolder.connection);
            try {
                return (Publisher)action.apply(connectionToUse);
            }
            catch (R2dbcException ex) {
                String sql = DefaultDatabaseClient.getSql(action);
                return Flux.error((Throwable)ConnectionFactoryUtils.convertR2dbcException("doInConnectionMany", sql, ex));
            }
        }, ConnectionCloseHolder::close, (it, err) -> it.close(), ConnectionCloseHolder::close).onErrorMap(R2dbcException.class, ex -> ConnectionFactoryUtils.convertR2dbcException("executeMany", DefaultDatabaseClient.getSql(action), ex));
    }

    private Mono<Connection> getConnection() {
        return ConnectionFactoryUtils.getConnection(this.obtainConnectionFactory());
    }

    private Publisher<Void> closeConnection(Connection connection) {
        return ConnectionFactoryUtils.currentConnectionFactory(this.obtainConnectionFactory()).then().onErrorResume(Exception.class, e -> Mono.from((Publisher)connection.close()));
    }

    private ConnectionFactory obtainConnectionFactory() {
        return this.connectionFactory;
    }

    private static Connection createConnectionProxy(Connection con) {
        return (Connection)Proxy.newProxyInstance(DatabaseClient.class.getClassLoader(), new Class[]{Connection.class, Wrapped.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(con));
    }

    private static Mono<Long> sumRowsUpdated(Function<Connection, Flux<Result>> resultFunction, Connection it) {
        return resultFunction.apply(it).flatMap(Result::getRowsUpdated).cast(Number.class).collect(Collectors.summingLong(Number::longValue));
    }

    @Nullable
    private static String getSql(Object object) {
        if (object instanceof SqlProvider) {
            SqlProvider sqlProvider = (SqlProvider)object;
            return sqlProvider.getSql();
        }
        return null;
    }

    class DefaultGenericExecuteSpec
    implements DatabaseClient.GenericExecuteSpec {
        final Map<Integer, io.r2dbc.spi.Parameter> byIndex;
        final Map<String, io.r2dbc.spi.Parameter> byName;
        final Supplier<String> sqlSupplier;
        final StatementFilterFunction filterFunction;

        DefaultGenericExecuteSpec(Supplier<String> sqlSupplier) {
            this.byIndex = Collections.emptyMap();
            this.byName = Collections.emptyMap();
            this.sqlSupplier = sqlSupplier;
            this.filterFunction = StatementFilterFunction.EMPTY_FILTER;
        }

        DefaultGenericExecuteSpec(Map<Integer, io.r2dbc.spi.Parameter> byIndex, Map<String, io.r2dbc.spi.Parameter> byName, Supplier<String> sqlSupplier, StatementFilterFunction filterFunction) {
            this.byIndex = byIndex;
            this.byName = byName;
            this.sqlSupplier = sqlSupplier;
            this.filterFunction = filterFunction;
        }

        @Override
        public DefaultGenericExecuteSpec bind(int index, Object value) {
            this.assertNotPreparedOperation();
            Assert.notNull((Object)value, () -> String.format("Value at index %d must not be null. Use bindNull(\u2026) instead.", index));
            LinkedHashMap<Integer, io.r2dbc.spi.Parameter> byIndex = new LinkedHashMap<Integer, io.r2dbc.spi.Parameter>(this.byIndex);
            if (value instanceof io.r2dbc.spi.Parameter) {
                io.r2dbc.spi.Parameter p = (io.r2dbc.spi.Parameter)value;
                byIndex.put(index, p);
            } else if (value instanceof Parameter) {
                Parameter p = (Parameter)value;
                byIndex.put(index, p.hasValue() ? Parameters.in((Object)p.getValue()) : Parameters.in(p.getType()));
            } else {
                byIndex.put(index, Parameters.in((Object)value));
            }
            return new DefaultGenericExecuteSpec(byIndex, this.byName, this.sqlSupplier, this.filterFunction);
        }

        @Override
        public DefaultGenericExecuteSpec bindNull(int index, Class<?> type) {
            this.assertNotPreparedOperation();
            LinkedHashMap<Integer, io.r2dbc.spi.Parameter> byIndex = new LinkedHashMap<Integer, io.r2dbc.spi.Parameter>(this.byIndex);
            byIndex.put(index, Parameters.in(type));
            return new DefaultGenericExecuteSpec(byIndex, this.byName, this.sqlSupplier, this.filterFunction);
        }

        @Override
        public DefaultGenericExecuteSpec bind(String name, Object value) {
            this.assertNotPreparedOperation();
            Assert.hasText((String)name, (String)"Parameter name must not be null or empty");
            Assert.notNull((Object)value, () -> String.format("Value for parameter %s must not be null. Use bindNull(\u2026) instead.", name));
            LinkedHashMap<String, io.r2dbc.spi.Parameter> byName = new LinkedHashMap<String, io.r2dbc.spi.Parameter>(this.byName);
            if (value instanceof io.r2dbc.spi.Parameter) {
                io.r2dbc.spi.Parameter p = (io.r2dbc.spi.Parameter)value;
                byName.put(name, p);
            } else if (value instanceof Parameter) {
                Parameter p = (Parameter)value;
                byName.put(name, p.hasValue() ? Parameters.in((Object)p.getValue()) : Parameters.in(p.getType()));
            } else {
                byName.put(name, Parameters.in((Object)value));
            }
            return new DefaultGenericExecuteSpec(this.byIndex, byName, this.sqlSupplier, this.filterFunction);
        }

        @Override
        public DefaultGenericExecuteSpec bindNull(String name, Class<?> type) {
            this.assertNotPreparedOperation();
            Assert.hasText((String)name, (String)"Parameter name must not be null or empty");
            LinkedHashMap<String, io.r2dbc.spi.Parameter> byName = new LinkedHashMap<String, io.r2dbc.spi.Parameter>(this.byName);
            byName.put(name, Parameters.in(type));
            return new DefaultGenericExecuteSpec(this.byIndex, byName, this.sqlSupplier, this.filterFunction);
        }

        @Override
        public DefaultGenericExecuteSpec filter(StatementFilterFunction filter) {
            Assert.notNull((Object)filter, (String)"StatementFilterFunction must not be null");
            return new DefaultGenericExecuteSpec(this.byIndex, this.byName, this.sqlSupplier, this.filterFunction.andThen(filter));
        }

        public <R> FetchSpec<R> map(Function<? super Readable, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null");
            return this.execute(this.sqlSupplier, result -> result.map(mappingFunction));
        }

        public <R> FetchSpec<R> map(BiFunction<Row, RowMetadata, R> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null");
            return this.execute(this.sqlSupplier, result -> result.map(mappingFunction));
        }

        @Override
        public <R> Flux<R> flatMap(Function<Result, Publisher<R>> mappingFunction) {
            Assert.notNull(mappingFunction, (String)"Mapping function must not be null");
            return this.flatMap(this.sqlSupplier, mappingFunction);
        }

        @Override
        public FetchSpec<Map<String, Object>> fetch() {
            return this.execute(this.sqlSupplier, result -> result.map((BiFunction)ColumnMapRowMapper.INSTANCE));
        }

        @Override
        public Mono<Void> then() {
            return this.fetch().rowsUpdated().then();
        }

        private ResultFunction getResultFunction(Supplier<String> sqlSupplier) {
            BiFunction<Connection, String, Statement> statementFunction = (connection, sql) -> {
                if (DefaultDatabaseClient.this.logger.isDebugEnabled()) {
                    DefaultDatabaseClient.this.logger.debug((Object)("Executing SQL statement [" + sql + "]"));
                }
                if (sqlSupplier instanceof PreparedOperation) {
                    PreparedOperation preparedOperation = (PreparedOperation)sqlSupplier;
                    Statement statement = connection.createStatement(sql);
                    StatementWrapper bindTarget = new StatementWrapper(statement);
                    preparedOperation.bindTo(bindTarget);
                    return statement;
                }
                if (DefaultDatabaseClient.this.namedParameterExpander != null) {
                    LinkedHashMap<String, io.r2dbc.spi.Parameter> remainderByName = new LinkedHashMap<String, io.r2dbc.spi.Parameter>(this.byName);
                    LinkedHashMap<Integer, io.r2dbc.spi.Parameter> remainderByIndex = new LinkedHashMap<Integer, io.r2dbc.spi.Parameter>(this.byIndex);
                    List<String> parameterNames = DefaultDatabaseClient.this.namedParameterExpander.getParameterNames((String)sql);
                    MapBindParameterSource namedBindings = this.retrieveParameters((String)sql, parameterNames, (Map<String, io.r2dbc.spi.Parameter>)remainderByName, (Map<Integer, io.r2dbc.spi.Parameter>)remainderByIndex);
                    PreparedOperation<String> operation = DefaultDatabaseClient.this.namedParameterExpander.expand((String)sql, DefaultDatabaseClient.this.bindMarkersFactory, namedBindings);
                    String expanded = this.getRequiredSql(operation);
                    if (DefaultDatabaseClient.this.logger.isTraceEnabled()) {
                        DefaultDatabaseClient.this.logger.trace((Object)("Expanded SQL [" + expanded + "]"));
                    }
                    Statement statement = connection.createStatement(expanded);
                    StatementWrapper bindTarget = new StatementWrapper(statement);
                    operation.bindTo(bindTarget);
                    this.bindByName(statement, remainderByName);
                    this.bindByIndex(statement, remainderByIndex);
                    return statement;
                }
                Statement statement = connection.createStatement(sql);
                this.bindByIndex(statement, this.byIndex);
                this.bindByName(statement, this.byName);
                return statement;
            };
            return new ResultFunction(sqlSupplier, statementFunction, this.filterFunction, DefaultDatabaseClient.this.executeFunction);
        }

        private <T> FetchSpec<T> execute(Supplier<String> sqlSupplier, Function<Result, Publisher<T>> resultAdapter) {
            ResultFunction resultHandler = this.getResultFunction(sqlSupplier);
            return new DefaultFetchSpec<T>(DefaultDatabaseClient.this, resultHandler, connection -> DefaultDatabaseClient.sumRowsUpdated(resultHandler, connection), resultAdapter);
        }

        private <T> Flux<T> flatMap(Supplier<String> sqlSupplier, Function<Result, Publisher<T>> mappingFunction) {
            ResultFunction resultHandler = this.getResultFunction(sqlSupplier);
            DelegateConnectionFunction connectionFunction = new DelegateConnectionFunction(resultHandler, cx -> resultHandler.apply((Connection)cx).flatMap(mappingFunction));
            return DefaultDatabaseClient.this.inConnectionMany(connectionFunction);
        }

        private MapBindParameterSource retrieveParameters(String sql, List<String> parameterNames, Map<String, io.r2dbc.spi.Parameter> remainderByName, Map<Integer, io.r2dbc.spi.Parameter> remainderByIndex) {
            LinkedHashMap namedBindings = CollectionUtils.newLinkedHashMap((int)parameterNames.size());
            for (String parameterName : parameterNames) {
                io.r2dbc.spi.Parameter parameter = this.getParameter(remainderByName, remainderByIndex, parameterNames, parameterName);
                if (parameter == null) {
                    throw new InvalidDataAccessApiUsageException(String.format("No parameter specified for [%s] in query [%s]", parameterName, sql));
                }
                namedBindings.put(parameterName, parameter);
            }
            return new MapBindParameterSource(namedBindings);
        }

        @Nullable
        private io.r2dbc.spi.Parameter getParameter(Map<String, io.r2dbc.spi.Parameter> remainderByName, Map<Integer, io.r2dbc.spi.Parameter> remainderByIndex, List<String> parameterNames, String parameterName) {
            if (this.byName.containsKey(parameterName)) {
                remainderByName.remove(parameterName);
                return this.byName.get(parameterName);
            }
            int index = parameterNames.indexOf(parameterName);
            if (this.byIndex.containsKey(index)) {
                remainderByIndex.remove(index);
                return this.byIndex.get(index);
            }
            return null;
        }

        private void assertNotPreparedOperation() {
            if (this.sqlSupplier instanceof PreparedOperation) {
                throw new InvalidDataAccessApiUsageException("Cannot add bindings to a PreparedOperation");
            }
        }

        private void bindByName(Statement statement, Map<String, io.r2dbc.spi.Parameter> byName) {
            byName.forEach((arg_0, arg_1) -> ((Statement)statement).bind(arg_0, arg_1));
        }

        private void bindByIndex(Statement statement, Map<Integer, io.r2dbc.spi.Parameter> byIndex) {
            byIndex.forEach((arg_0, arg_1) -> ((Statement)statement).bind(arg_0, arg_1));
        }

        private String getRequiredSql(Supplier<String> sqlSupplier) {
            String sql = sqlSupplier.get();
            Assert.state((boolean)StringUtils.hasText((String)sql), (String)"SQL returned by supplier must not be empty");
            return sql;
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "unwrap": {
                    return this.target;
                }
                case "close": {
                    return Mono.error((Throwable)new UnsupportedOperationException("Close is not supported!"));
                }
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    static class ConnectionCloseHolder
    extends AtomicBoolean {
        private static final long serialVersionUID = -8994138383301201380L;
        final transient Connection connection;
        final transient Function<Connection, Publisher<Void>> closeFunction;

        ConnectionCloseHolder(Connection connection, Function<Connection, Publisher<Void>> closeFunction) {
            this.connection = connection;
            this.closeFunction = closeFunction;
        }

        Mono<Void> close() {
            return Mono.defer(() -> {
                if (this.compareAndSet(false, true)) {
                    return Mono.from(this.closeFunction.apply(this.connection));
                }
                return Mono.empty();
            });
        }
    }

    static class StatementWrapper
    implements BindTarget {
        final Statement statement;

        StatementWrapper(Statement statement) {
            this.statement = statement;
        }

        @Override
        public void bind(String identifier, Object value) {
            this.statement.bind(identifier, value);
        }

        @Override
        public void bind(int index, Object value) {
            this.statement.bind(index, value);
        }

        @Override
        public void bindNull(String identifier, Class<?> type) {
            this.statement.bindNull(identifier, type);
        }

        @Override
        public void bindNull(int index, Class<?> type) {
            this.statement.bindNull(index, type);
        }
    }
}

