/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection.init;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Result;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.connection.init.CannotReadScriptException;
import org.springframework.r2dbc.connection.init.ScriptException;
import org.springframework.r2dbc.connection.init.ScriptParseException;
import org.springframework.r2dbc.connection.init.ScriptStatementFailedException;
import org.springframework.r2dbc.connection.init.UncategorizedScriptException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ScriptUtils {
    public static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    public static final String FALLBACK_STATEMENT_SEPARATOR = "\n";
    public static final String EOF_STATEMENT_SEPARATOR = "^^^ END OF SCRIPT ^^^";
    public static final String DEFAULT_COMMENT_PREFIX = "--";
    public static final String[] DEFAULT_COMMENT_PREFIXES = new String[]{"--"};
    public static final String DEFAULT_BLOCK_COMMENT_START_DELIMITER = "/*";
    public static final String DEFAULT_BLOCK_COMMENT_END_DELIMITER = "*/";
    private static final Log logger = LogFactory.getLog(ScriptUtils.class);

    public static void splitSqlScript(String script, char separator, List<String> statements) throws ScriptException {
        ScriptUtils.splitSqlScript(script, String.valueOf(separator), statements);
    }

    public static void splitSqlScript(String script, String separator, List<String> statements) throws ScriptException {
        ScriptUtils.splitSqlScript(null, script, separator, DEFAULT_COMMENT_PREFIX, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER, statements);
    }

    public static void splitSqlScript(@Nullable EncodedResource resource, String script, String separator, String commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) throws ScriptException {
        Assert.hasText((String)commentPrefix, (String)"'commentPrefix' must not be null or empty");
        ScriptUtils.splitSqlScript(resource, script, separator, new String[]{commentPrefix}, blockCommentStartDelimiter, blockCommentEndDelimiter, statements);
    }

    public static void splitSqlScript(@Nullable EncodedResource resource, String script, String separator, String[] commentPrefixes, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) throws ScriptException {
        Assert.hasText((String)script, (String)"'script' must not be null or empty");
        Assert.notNull((Object)separator, (String)"'separator' must not be null");
        Assert.notEmpty((Object[])commentPrefixes, (String)"'commentPrefixes' must not be null or empty");
        for (String commentPrefix : commentPrefixes) {
            Assert.hasText((String)commentPrefix, (String)"'commentPrefixes' must not contain null or empty elements");
        }
        Assert.hasText((String)blockCommentStartDelimiter, (String)"'blockCommentStartDelimiter' must not be null or empty");
        Assert.hasText((String)blockCommentEndDelimiter, (String)"'blockCommentEndDelimiter' must not be null or empty");
        StringBuilder sb = new StringBuilder();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            int c = script.charAt(i);
            if (inEscape) {
                inEscape = false;
                sb.append((char)c);
                continue;
            }
            if (c == 92) {
                inEscape = true;
                sb.append((char)c);
                continue;
            }
            if (!inDoubleQuote && c == 39) {
                inSingleQuote = !inSingleQuote;
            } else if (!inSingleQuote && c == 34) {
                boolean bl = inDoubleQuote = !inDoubleQuote;
            }
            if (!inSingleQuote && !inDoubleQuote) {
                if (script.startsWith(separator, i)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += separator.length() - 1;
                    continue;
                }
                if (ScriptUtils.startsWithAny(script, commentPrefixes, i)) {
                    int indexOfNextNewline = script.indexOf(10, i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (script.startsWith(blockCommentStartDelimiter, i)) {
                    int indexOfCommentEnd = script.indexOf(blockCommentEndDelimiter, i);
                    if (indexOfCommentEnd > i) {
                        i = indexOfCommentEnd + blockCommentEndDelimiter.length() - 1;
                        continue;
                    }
                    throw new ScriptParseException("Missing block comment end delimiter: " + blockCommentEndDelimiter, resource);
                }
                if (c == 32 || c == 13 || c == 10 || c == 9) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = 32;
                }
            }
            sb.append((char)c);
        }
        if (StringUtils.hasText((CharSequence)sb)) {
            statements.add(sb.toString());
        }
    }

    public static Mono<String> readScript(EncodedResource resource, DataBufferFactory dataBufferFactory) {
        return ScriptUtils.readScript(resource, dataBufferFactory, DEFAULT_COMMENT_PREFIXES, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    private static Mono<String> readScript(EncodedResource resource, DataBufferFactory dataBufferFactory, @Nullable String[] commentPrefixes, @Nullable String separator, @Nullable String blockCommentEndDelimiter) {
        return DataBufferUtils.join((Publisher)DataBufferUtils.read((Resource)resource.getResource(), (DataBufferFactory)dataBufferFactory, (int)8192)).handle((it, sink) -> {
            try (InputStream is = it.asInputStream();){
                InputStreamReader in = resource.getCharset() != null ? new InputStreamReader(is, resource.getCharset()) : new InputStreamReader(is);
                LineNumberReader lnr = new LineNumberReader(in);
                String script = ScriptUtils.readScript(lnr, commentPrefixes, separator, blockCommentEndDelimiter);
                sink.next((Object)script);
                sink.complete();
            }
            catch (Exception ex) {
                sink.error((Throwable)ex);
            }
            finally {
                DataBufferUtils.release((DataBuffer)it);
            }
        });
    }

    public static String readScript(LineNumberReader lineNumberReader, @Nullable String lineCommentPrefix, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        String[] stringArray;
        if (lineCommentPrefix != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = lineCommentPrefix;
        } else {
            stringArray = null;
        }
        String[] lineCommentPrefixes = stringArray;
        return ScriptUtils.readScript(lineNumberReader, lineCommentPrefixes, separator, blockCommentEndDelimiter);
    }

    public static String readScript(LineNumberReader lineNumberReader, @Nullable String[] lineCommentPrefixes, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (blockCommentEndDelimiter != null && currentStatement.contains(blockCommentEndDelimiter) || lineCommentPrefixes != null && !ScriptUtils.startsWithAny(currentStatement, lineCommentPrefixes, 0)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        ScriptUtils.appendSeparatorToScriptIfNecessary(scriptBuilder, separator);
        return scriptBuilder.toString();
    }

    private static void appendSeparatorToScriptIfNecessary(StringBuilder scriptBuilder, @Nullable String separator) {
        if (separator == null) {
            return;
        }
        String trimmed = separator.trim();
        if (trimmed.length() == separator.length()) {
            return;
        }
        if (scriptBuilder.lastIndexOf(trimmed) == scriptBuilder.length() - trimmed.length()) {
            scriptBuilder.append(separator.substring(trimmed.length()));
        }
    }

    private static boolean startsWithAny(String script, String[] prefixes, int offset) {
        for (String prefix : prefixes) {
            if (!script.startsWith(prefix, offset)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            char c = script.charAt(i);
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            if (c == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(delim, i)) continue;
            return true;
        }
        return false;
    }

    public static Mono<Void> executeSqlScript(Connection connection, Resource resource) throws ScriptException {
        return ScriptUtils.executeSqlScript(connection, new EncodedResource(resource));
    }

    public static Mono<Void> executeSqlScript(Connection connection, EncodedResource resource) throws ScriptException {
        return ScriptUtils.executeSqlScript(connection, resource, (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, false, false, DEFAULT_COMMENT_PREFIX, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    public static Mono<Void> executeSqlScript(Connection connection, EncodedResource resource, DataBufferFactory dataBufferFactory, boolean continueOnError, boolean ignoreFailedDrops, String commentPrefix, @Nullable String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) throws ScriptException {
        return ScriptUtils.executeSqlScript(connection, resource, dataBufferFactory, continueOnError, ignoreFailedDrops, new String[]{commentPrefix}, separator, blockCommentStartDelimiter, blockCommentEndDelimiter);
    }

    public static Mono<Void> executeSqlScript(Connection connection, EncodedResource resource, DataBufferFactory dataBufferFactory, boolean continueOnError, boolean ignoreFailedDrops, String[] commentPrefixes, @Nullable String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) throws ScriptException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing SQL script from " + resource));
        }
        long startTime = System.currentTimeMillis();
        Mono script = ScriptUtils.readScript(resource, dataBufferFactory, commentPrefixes, separator, blockCommentEndDelimiter).onErrorMap(IOException.class, ex -> new CannotReadScriptException(resource, (Throwable)ex));
        AtomicInteger statementNumber = new AtomicInteger();
        Flux executeScript = script.flatMapIterable(statement -> {
            ArrayList<String> statements = new ArrayList<String>();
            String separatorToUse = separator;
            if (separatorToUse == null) {
                separatorToUse = DEFAULT_STATEMENT_SEPARATOR;
            }
            if (!EOF_STATEMENT_SEPARATOR.equals(separatorToUse) && !ScriptUtils.containsSqlScriptDelimiters(statement, separatorToUse)) {
                separatorToUse = FALLBACK_STATEMENT_SEPARATOR;
            }
            ScriptUtils.splitSqlScript(resource, statement, separatorToUse, commentPrefixes, blockCommentStartDelimiter, blockCommentEndDelimiter, statements);
            return statements;
        }).concatMap(statement -> {
            statementNumber.incrementAndGet();
            return ScriptUtils.runStatement(statement, connection, resource, continueOnError, ignoreFailedDrops, statementNumber);
        });
        if (logger.isDebugEnabled()) {
            executeScript = executeScript.doOnComplete(() -> {
                long elapsedTime = System.currentTimeMillis() - startTime;
                logger.debug((Object)("Executed SQL script from " + resource + " in " + elapsedTime + " ms."));
            });
        }
        return executeScript.onErrorMap(ex -> !(ex instanceof ScriptException), ex -> new UncategorizedScriptException("Failed to execute database script from resource [" + resource + "]", (Throwable)ex)).then();
    }

    private static Publisher<? extends Void> runStatement(String statement, Connection connection, EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops, AtomicInteger statementNumber) {
        Mono execution = Flux.from((Publisher)connection.createStatement(statement).execute()).flatMap(Result::getRowsUpdated).collect(Collectors.summingLong(count -> count.intValue()));
        if (logger.isDebugEnabled()) {
            execution = execution.doOnNext(rowsAffected -> logger.debug((Object)(rowsAffected + " returned as update count for SQL: " + statement)));
        }
        return execution.onErrorResume(ex -> {
            boolean dropStatement = StringUtils.startsWithIgnoreCase((String)statement.trim(), (String)"drop");
            if (continueOnError || dropStatement && ignoreFailedDrops) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)ScriptStatementFailedException.buildErrorMessage(statement, statementNumber.get(), resource), ex);
                }
            } else {
                return Mono.error((Throwable)((Object)new ScriptStatementFailedException(statement, statementNumber.get(), resource, (Throwable)ex)));
            }
            return Mono.empty();
        }).then();
    }
}

