/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Result;
import java.time.Duration;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.connection.ConnectionFactoryUtils;
import org.springframework.r2dbc.connection.ConnectionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.reactive.AbstractReactiveTransactionManager;
import org.springframework.transaction.reactive.GenericReactiveTransaction;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class R2dbcTransactionManager
extends AbstractReactiveTransactionManager
implements InitializingBean {
    @Nullable
    private ConnectionFactory connectionFactory;
    private boolean enforceReadOnly = false;

    public R2dbcTransactionManager() {
    }

    public R2dbcTransactionManager(ConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    public void setConnectionFactory(@Nullable ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Nullable
    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected ConnectionFactory obtainConnectionFactory() {
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        Assert.state((connectionFactory != null ? 1 : 0) != 0, (String)"No ConnectionFactory set");
        return connectionFactory;
    }

    public void setEnforceReadOnly(boolean enforceReadOnly) {
        this.enforceReadOnly = enforceReadOnly;
    }

    public boolean isEnforceReadOnly() {
        return this.enforceReadOnly;
    }

    public void afterPropertiesSet() {
        if (this.getConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
    }

    protected Object doGetTransaction(TransactionSynchronizationManager synchronizationManager) throws TransactionException {
        ConnectionFactoryTransactionObject txObject = new ConnectionFactoryTransactionObject();
        ConnectionHolder conHolder = (ConnectionHolder)((Object)synchronizationManager.getResource((Object)this.obtainConnectionFactory()));
        txObject.setConnectionHolder(conHolder, false);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)transaction;
        return txObject.hasConnectionHolder() && txObject.getConnectionHolder().isTransactionActive();
    }

    protected Mono<Void> doBegin(TransactionSynchronizationManager synchronizationManager, Object transaction, TransactionDefinition definition) throws TransactionException {
        ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)transaction;
        return Mono.defer(() -> {
            Mono connectionMono;
            if (!txObject.hasConnectionHolder() || txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
                Mono newCon = Mono.from((Publisher)this.obtainConnectionFactory().create());
                connectionMono = newCon.doOnNext(connection -> {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Acquired Connection [" + newCon + "] for R2DBC transaction"));
                    }
                    txObject.setConnectionHolder(new ConnectionHolder((Connection)connection), true);
                });
            } else {
                txObject.getConnectionHolder().setSynchronizedWithTransaction(true);
                connectionMono = Mono.just((Object)txObject.getConnectionHolder().getConnection());
            }
            return connectionMono.flatMap(con -> this.prepareTransactionalConnection((Connection)con, definition, transaction).then(Mono.from((Publisher)con.beginTransaction())).doOnSuccess(v -> {
                txObject.getConnectionHolder().setTransactionActive(true);
                Duration timeout = this.determineTimeout(definition);
                if (!timeout.isNegative() && !timeout.isZero()) {
                    txObject.getConnectionHolder().setTimeoutInMillis(timeout.toMillis());
                }
                if (txObject.isNewConnectionHolder()) {
                    synchronizationManager.bindResource((Object)this.obtainConnectionFactory(), (Object)txObject.getConnectionHolder());
                }
            }).thenReturn(con).onErrorResume(e -> {
                if (txObject.isNewConnectionHolder()) {
                    return ConnectionFactoryUtils.releaseConnection(con, this.obtainConnectionFactory()).doOnTerminate(() -> txObject.setConnectionHolder(null, false)).then(Mono.error((Throwable)e));
                }
                return Mono.error((Throwable)e);
            })).onErrorResume(e -> {
                CannotCreateTransactionException ex = new CannotCreateTransactionException("Could not open R2DBC Connection for transaction", e);
                return Mono.error((Throwable)ex);
            });
        }).then();
    }

    protected Duration determineTimeout(TransactionDefinition definition) {
        if (definition.getTimeout() != -1) {
            return Duration.ofSeconds(definition.getTimeout());
        }
        return Duration.ZERO;
    }

    protected Mono<Object> doSuspend(TransactionSynchronizationManager synchronizationManager, Object transaction) throws TransactionException {
        return Mono.defer(() -> {
            ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)transaction;
            txObject.setConnectionHolder(null);
            return Mono.justOrEmpty((Object)synchronizationManager.unbindResource((Object)this.obtainConnectionFactory()));
        });
    }

    protected Mono<Void> doResume(TransactionSynchronizationManager synchronizationManager, @Nullable Object transaction, Object suspendedResources) throws TransactionException {
        return Mono.defer(() -> {
            synchronizationManager.bindResource((Object)this.obtainConnectionFactory(), suspendedResources);
            return Mono.empty();
        });
    }

    protected Mono<Void> doCommit(TransactionSynchronizationManager TransactionSynchronizationManager2, GenericReactiveTransaction status) throws TransactionException {
        ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)status.getTransaction();
        Connection connection = txObject.getConnectionHolder().getConnection();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing R2DBC transaction on Connection [" + connection + "]"));
        }
        return Mono.from((Publisher)connection.commitTransaction()).onErrorMap(R2dbcException.class, ex -> this.translateException("R2DBC commit", (R2dbcException)ex));
    }

    protected Mono<Void> doRollback(TransactionSynchronizationManager TransactionSynchronizationManager2, GenericReactiveTransaction status) throws TransactionException {
        ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)status.getTransaction();
        Connection connection = txObject.getConnectionHolder().getConnection();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back R2DBC transaction on Connection [" + connection + "]"));
        }
        return Mono.from((Publisher)connection.rollbackTransaction()).onErrorMap(R2dbcException.class, ex -> this.translateException("R2DBC rollback", (R2dbcException)ex));
    }

    protected Mono<Void> doSetRollbackOnly(TransactionSynchronizationManager synchronizationManager, GenericReactiveTransaction status) throws TransactionException {
        return Mono.fromRunnable(() -> {
            ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)status.getTransaction();
            if (status.isDebug()) {
                this.logger.debug((Object)("Setting R2DBC transaction [" + txObject.getConnectionHolder().getConnection() + "] rollback-only"));
            }
            txObject.setRollbackOnly();
        });
    }

    protected Mono<Void> doCleanupAfterCompletion(TransactionSynchronizationManager synchronizationManager, Object transaction) {
        return Mono.defer(() -> {
            ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)transaction;
            if (txObject.isNewConnectionHolder()) {
                synchronizationManager.unbindResource((Object)this.obtainConnectionFactory());
            }
            Connection con = txObject.getConnectionHolder().getConnection();
            Mono afterCleanup = Mono.empty();
            if (txObject.isMustRestoreAutoCommit()) {
                afterCleanup = afterCleanup.then(Mono.from((Publisher)con.setAutoCommit(true)));
            }
            if (txObject.getPreviousIsolationLevel() != null) {
                afterCleanup = afterCleanup.then(Mono.from((Publisher)con.setTransactionIsolationLevel(txObject.getPreviousIsolationLevel())));
            }
            return afterCleanup.then(Mono.defer(() -> {
                try {
                    if (txObject.isNewConnectionHolder()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Releasing R2DBC Connection [" + con + "] after transaction"));
                        }
                        Mono<Void> mono = ConnectionFactoryUtils.releaseConnection(con, this.obtainConnectionFactory());
                        return mono;
                    }
                }
                finally {
                    txObject.getConnectionHolder().clear();
                }
                return Mono.empty();
            }));
        });
    }

    protected Mono<Void> prepareTransactionalConnection(Connection con, TransactionDefinition definition, Object transaction) {
        IsolationLevel isolationLevelToUse;
        ConnectionFactoryTransactionObject txObject = (ConnectionFactoryTransactionObject)transaction;
        Mono prepare = Mono.empty();
        if (this.isEnforceReadOnly() && definition.isReadOnly()) {
            prepare = Mono.from((Publisher)con.createStatement("SET TRANSACTION READ ONLY").execute()).flatMapMany(Result::getRowsUpdated).then();
        }
        if ((isolationLevelToUse = this.resolveIsolationLevel(definition.getIsolationLevel())) != null && definition.getIsolationLevel() != -1) {
            IsolationLevel currentIsolation;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Changing isolation level of R2DBC Connection [" + con + "] to " + isolationLevelToUse.asSql()));
            }
            if (!(currentIsolation = con.getTransactionIsolationLevel()).asSql().equalsIgnoreCase(isolationLevelToUse.asSql())) {
                txObject.setPreviousIsolationLevel(currentIsolation);
                prepare = prepare.then(Mono.from((Publisher)con.setTransactionIsolationLevel(isolationLevelToUse)));
            }
        }
        if (con.isAutoCommit()) {
            txObject.setMustRestoreAutoCommit(true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Switching R2DBC Connection [" + con + "] to manual commit"));
            }
            prepare = prepare.then(Mono.from((Publisher)con.setAutoCommit(false)));
        }
        return prepare;
    }

    @Nullable
    protected IsolationLevel resolveIsolationLevel(int isolationLevel) {
        switch (isolationLevel) {
            case 2: {
                return IsolationLevel.READ_COMMITTED;
            }
            case 1: {
                return IsolationLevel.READ_UNCOMMITTED;
            }
            case 4: {
                return IsolationLevel.REPEATABLE_READ;
            }
            case 8: {
                return IsolationLevel.SERIALIZABLE;
            }
        }
        return null;
    }

    protected RuntimeException translateException(String task, R2dbcException ex) {
        return ConnectionFactoryUtils.convertR2dbcException(task, null, ex);
    }

    private static class ConnectionFactoryTransactionObject {
        @Nullable
        private ConnectionHolder connectionHolder;
        @Nullable
        private IsolationLevel previousIsolationLevel;
        private boolean newConnectionHolder;
        private boolean mustRestoreAutoCommit;

        private ConnectionFactoryTransactionObject() {
        }

        void setConnectionHolder(@Nullable ConnectionHolder connectionHolder, boolean newConnectionHolder) {
            this.setConnectionHolder(connectionHolder);
            this.newConnectionHolder = newConnectionHolder;
        }

        boolean isNewConnectionHolder() {
            return this.newConnectionHolder;
        }

        void setRollbackOnly() {
            this.getConnectionHolder().setRollbackOnly();
        }

        public void setConnectionHolder(@Nullable ConnectionHolder connectionHolder) {
            this.connectionHolder = connectionHolder;
        }

        public ConnectionHolder getConnectionHolder() {
            Assert.state((this.connectionHolder != null ? 1 : 0) != 0, (String)"No ConnectionHolder available");
            return this.connectionHolder;
        }

        public boolean hasConnectionHolder() {
            return this.connectionHolder != null;
        }

        public void setPreviousIsolationLevel(@Nullable IsolationLevel previousIsolationLevel) {
            this.previousIsolationLevel = previousIsolationLevel;
        }

        @Nullable
        public IsolationLevel getPreviousIsolationLevel() {
            return this.previousIsolationLevel;
        }

        public void setMustRestoreAutoCommit(boolean mustRestoreAutoCommit) {
            this.mustRestoreAutoCommit = mustRestoreAutoCommit;
        }

        public boolean isMustRestoreAutoCommit() {
            return this.mustRestoreAutoCommit;
        }
    }
}

