/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection.init;

import io.r2dbc.spi.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.r2dbc.connection.init.DatabasePopulator;
import org.springframework.r2dbc.connection.init.ScriptException;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeDatabasePopulator
implements DatabasePopulator {
    private final List<DatabasePopulator> populators = new ArrayList<DatabasePopulator>(4);

    public CompositeDatabasePopulator() {
    }

    public CompositeDatabasePopulator(Collection<DatabasePopulator> populators) {
        Assert.notNull(populators, (String)"DatabasePopulators must not be null");
        this.populators.addAll(populators);
    }

    public CompositeDatabasePopulator(DatabasePopulator ... populators) {
        Assert.notNull((Object)populators, (String)"DatabasePopulators must not be null");
        this.populators.addAll(Arrays.asList(populators));
    }

    public void setPopulators(DatabasePopulator ... populators) {
        Assert.notNull((Object)populators, (String)"DatabasePopulators must not be null");
        this.populators.clear();
        this.populators.addAll(Arrays.asList(populators));
    }

    public void addPopulators(DatabasePopulator ... populators) {
        Assert.notNull((Object)populators, (String)"DatabasePopulators must not be null");
        this.populators.addAll(Arrays.asList(populators));
    }

    @Override
    public Mono<Void> populate(Connection connection) throws ScriptException {
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        return Flux.fromIterable(this.populators).concatMap(populator -> populator.populate(connection)).then();
    }
}

