/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection.lookup;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.connection.lookup.ConnectionFactoryLookup;
import org.springframework.r2dbc.connection.lookup.MapConnectionFactoryLookup;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class AbstractRoutingConnectionFactory
implements ConnectionFactory,
InitializingBean {
    private static final Object FALLBACK_MARKER = new Object();
    @Nullable
    private Map<?, ?> targetConnectionFactories;
    @Nullable
    private Object defaultTargetConnectionFactory;
    private boolean lenientFallback = true;
    private ConnectionFactoryLookup connectionFactoryLookup = new MapConnectionFactoryLookup();
    @Nullable
    private Map<Object, ConnectionFactory> resolvedConnectionFactories;
    @Nullable
    private ConnectionFactory resolvedDefaultConnectionFactory;

    public void setTargetConnectionFactories(Map<?, ?> targetConnectionFactories) {
        this.targetConnectionFactories = targetConnectionFactories;
    }

    public void setDefaultTargetConnectionFactory(Object defaultTargetConnectionFactory) {
        this.defaultTargetConnectionFactory = defaultTargetConnectionFactory;
    }

    public void setLenientFallback(boolean lenientFallback) {
        this.lenientFallback = lenientFallback;
    }

    public void setConnectionFactoryLookup(ConnectionFactoryLookup connectionFactoryLookup) {
        Assert.notNull((Object)connectionFactoryLookup, (String)"ConnectionFactoryLookup must not be null");
        this.connectionFactoryLookup = connectionFactoryLookup;
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.targetConnectionFactories, (String)"Property 'targetConnectionFactories' must not be null");
        this.resolvedConnectionFactories = new HashMap<Object, ConnectionFactory>(this.targetConnectionFactories.size());
        this.targetConnectionFactories.forEach((key, value) -> {
            Object lookupKey = this.resolveSpecifiedLookupKey(key);
            ConnectionFactory connectionFactory = this.resolveSpecifiedConnectionFactory(value);
            this.resolvedConnectionFactories.put(lookupKey, connectionFactory);
        });
        if (this.defaultTargetConnectionFactory != null) {
            this.resolvedDefaultConnectionFactory = this.resolveSpecifiedConnectionFactory(this.defaultTargetConnectionFactory);
        }
    }

    protected Object resolveSpecifiedLookupKey(Object lookupKey) {
        return lookupKey;
    }

    protected ConnectionFactory resolveSpecifiedConnectionFactory(Object connectionFactory) throws IllegalArgumentException {
        if (connectionFactory instanceof ConnectionFactory) {
            return (ConnectionFactory)connectionFactory;
        }
        if (connectionFactory instanceof String) {
            return this.connectionFactoryLookup.getConnectionFactory((String)connectionFactory);
        }
        throw new IllegalArgumentException("Illegal connection factory value - only 'io.r2dbc.spi.ConnectionFactory' and 'String' supported: " + connectionFactory);
    }

    public Mono<Connection> create() {
        return this.determineTargetConnectionFactory().map(ConnectionFactory::create).flatMap(Mono::from);
    }

    public ConnectionFactoryMetadata getMetadata() {
        if (this.resolvedDefaultConnectionFactory != null) {
            return this.resolvedDefaultConnectionFactory.getMetadata();
        }
        throw new UnsupportedOperationException("No default ConnectionFactory configured to retrieve ConnectionFactoryMetadata");
    }

    protected Mono<ConnectionFactory> determineTargetConnectionFactory() {
        Assert.state((this.resolvedConnectionFactories != null ? 1 : 0) != 0, (String)"ConnectionFactory router not initialized");
        Mono lookupKey = this.determineCurrentLookupKey().defaultIfEmpty(FALLBACK_MARKER);
        return lookupKey.handle((key, sink) -> {
            ConnectionFactory connectionFactory = this.resolvedConnectionFactories.get(key);
            if (connectionFactory == null && (key == FALLBACK_MARKER || this.lenientFallback)) {
                connectionFactory = this.resolvedDefaultConnectionFactory;
            }
            if (connectionFactory == null) {
                sink.error((Throwable)new IllegalStateException(String.format("Cannot determine target ConnectionFactory for lookup key '%s'", key == FALLBACK_MARKER ? null : key)));
                return;
            }
            sink.next((Object)connectionFactory);
        });
    }

    protected abstract Mono<Object> determineCurrentLookupKey();
}

