/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.Wrapped;
import org.reactivestreams.Publisher;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class DelegatingConnectionFactory
implements ConnectionFactory,
Wrapped<ConnectionFactory> {
    private final ConnectionFactory targetConnectionFactory;

    public DelegatingConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull((Object)targetConnectionFactory, (String)"ConnectionFactory must not be null");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public Mono<? extends Connection> create() {
        return Mono.from((Publisher)this.targetConnectionFactory.create());
    }

    public ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public ConnectionFactoryMetadata getMetadata() {
        return this.obtainTargetConnectionFactory().getMetadata();
    }

    public ConnectionFactory unwrap() {
        return this.obtainTargetConnectionFactory();
    }

    protected ConnectionFactory obtainTargetConnectionFactory() {
        return this.getTargetConnectionFactory();
    }
}

