/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.core.CollectionFactory;
import org.springframework.mock.web.DelegatingServletInputStream;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockRequestDispatcher;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;

public class MockHttpServletRequest
implements HttpServletRequest {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_SERVER_ADDR = "127.0.0.1";
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final int DEFAULT_SERVER_PORT = 80;
    public static final String DEFAULT_REMOTE_ADDR = "127.0.0.1";
    public static final String DEFAULT_REMOTE_HOST = "localhost";
    private final Hashtable attributes = new Hashtable();
    private String characterEncoding;
    private byte[] content;
    private String contentType;
    private final Map parameters = CollectionFactory.createLinkedMapIfPossible((int)16);
    private String protocol = "http";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private final Vector locales = new Vector();
    private boolean secure = false;
    private final ServletContext servletContext;
    private int remotePort = 80;
    private String localName = "localhost";
    private String localAddr = "127.0.0.1";
    private int localPort = 80;
    private String authType;
    private Cookie[] cookies;
    private final Map headers = new Hashtable();
    private String method;
    private String pathInfo;
    private String contextPath = "";
    private String queryString;
    private String remoteUser;
    private final Set userRoles = new HashSet();
    private Principal userPrincipal;
    private String requestURI = "";
    private String servletPath = "";
    private HttpSession session;
    private boolean requestedSessionIdValid = true;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;

    public MockHttpServletRequest(ServletContext servletContext) {
        this.locales.add(Locale.ENGLISH);
        this.servletContext = servletContext;
    }

    public MockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
        this(servletContext);
        this.method = method;
        this.requestURI = requestURI;
    }

    public MockHttpServletRequest() {
        this(new MockServletContext());
    }

    public MockHttpServletRequest(String method, String requestURI) {
        this(new MockServletContext(), method, requestURI);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() {
        if (this.content != null) {
            return new DelegatingServletInputStream(new ByteArrayInputStream(this.content));
        }
        return null;
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.parameters.put(name, values);
    }

    public void addParameter(String name, String value) {
        this.addParameter(name, new String[]{value});
    }

    public void addParameter(String name, String[] values) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        String[] oldArr = (String[])this.parameters.get(name);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + values.length];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            System.arraycopy(values, 0, newArr, oldArr.length, values.length);
            this.parameters.put(name, newArr);
        } else {
            this.parameters.put(name, values);
        }
    }

    public void removeParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.parameters.remove(name);
    }

    public String getParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        String[] arr = (String[])this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return null;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, Object value) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        this.attributes.remove(name);
    }

    public void addPreferredLocale(Locale locale) {
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        this.locales.add(0, locale);
    }

    public Locale getLocale() {
        return (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        return this.locales.elements();
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void addHeader(String name, Object value) {
        Assert.notNull((Object)name, (String)"Header name must not be null");
        Assert.notNull((Object)value, (String)"Header value must not be null");
        HttpHeader header = (HttpHeader)this.headers.get(name.toLowerCase());
        if (header == null) {
            header = new HttpHeader(name);
            this.headers.put(name.toLowerCase(), header);
        }
        if (value instanceof Collection) {
            header.addValues((Collection)value);
        } else if (value.getClass().isArray()) {
            header.addValues((Object[])value);
        } else {
            header.addValue(value);
        }
    }

    public long getDateHeader(String name) {
        Object value;
        Assert.notNull((Object)name, (String)"Header name must not be null");
        HttpHeader header = (HttpHeader)this.headers.get(name.toLowerCase());
        Object object = value = header == null ? null : header.getValue();
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value != null) {
            throw new IllegalArgumentException("Value for header '" + name + "' is neither a Date nor a Number: " + value);
        }
        return -1L;
    }

    public String getHeader(String name) {
        HttpHeader header = (HttpHeader)this.headers.get(name.toLowerCase());
        return header == null ? null : header.getValue().toString();
    }

    public Enumeration getHeaders(String name) {
        HttpHeader header = (HttpHeader)this.headers.get(name.toLowerCase());
        return Collections.enumeration(header == null ? Collections.EMPTY_LIST : header.getValues());
    }

    public Enumeration getHeaderNames() {
        return new HttpHeaderNamesEnumerator(this.headers.values());
    }

    public int getIntHeader(String name) {
        Object value;
        Assert.notNull((Object)name, (String)"Header name must not be null");
        HttpHeader header = (HttpHeader)this.headers.get(name.toLowerCase());
        Object object = value = header == null ? null : header.getValue();
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value != null) {
            throw new NumberFormatException("Value for header '" + name + "' is not a Number : " + value);
        }
        return -1;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void addRole(String role) {
        this.addUserRole(role);
    }

    public void addUserRole(String role) {
        this.userRoles.add(role);
    }

    public boolean isUserInRole(String role) {
        return this.userRoles.contains(role);
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        HttpSession session = this.getSession();
        return session != null ? session.getId() : null;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(this.scheme);
        url.append("://").append(this.serverName).append(':').append(this.serverPort);
        url.append(this.getRequestURI());
        return url;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setSession(HttpSession session) {
        this.session = session;
        if (session instanceof MockHttpSession) {
            MockHttpSession mockSession = (MockHttpSession)session;
            mockSession.access();
        }
    }

    public HttpSession getSession(boolean create) {
        if (this.session instanceof MockHttpSession && ((MockHttpSession)this.session).isInvalid()) {
            this.session = null;
        }
        if (this.session == null && create) {
            this.session = new MockHttpSession(this.servletContext);
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    private static final class HttpHeaderNamesEnumerator
    implements Enumeration {
        private Iterator httpHeaderIterator;

        HttpHeaderNamesEnumerator(Collection headers) {
            Assert.notNull((Object)"Headers must not be null.");
            this.httpHeaderIterator = headers.iterator();
        }

        public boolean hasMoreElements() {
            return this.httpHeaderIterator.hasNext();
        }

        public Object nextElement() {
            return ((HttpHeader)this.httpHeaderIterator.next()).getName();
        }
    }

    private static final class HttpHeader {
        private String name;
        private List values = new LinkedList();

        HttpHeader(String name) {
            Assert.notNull((Object)name, (String)"The header name cannot be null.");
            this.name = name;
        }

        void addValue(Object value) {
            Assert.notNull((Object)this.values, (String)"Value must not be null.");
            this.values.add(value);
        }

        void addValues(Collection values) {
            Assert.notNull((Object)values, (String)"Values collection must not be null.");
            Iterator it = values.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                Assert.notNull(element, (String)"Value collection must not contain null elements.");
                this.values.add(element);
            }
        }

        void addValues(Object[] values) {
            this.values.addAll(Arrays.asList(values));
        }

        String getName() {
            return this.name;
        }

        List getValues() {
            return this.values;
        }

        Object getValue() {
            return this.values.isEmpty() ? null : this.values.get(0);
        }
    }
}

