/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserDestinationResult;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultUserDestinationResolver
implements UserDestinationResolver {
    private static final Log logger = LogFactory.getLog(DefaultUserDestinationResolver.class);
    private final UserSessionRegistry userSessionRegistry;
    private String destinationPrefix = "/user/";

    public DefaultUserDestinationResolver(UserSessionRegistry userSessionRegistry) {
        Assert.notNull((Object)userSessionRegistry, (String)"'userSessionRegistry' must not be null");
        this.userSessionRegistry = userSessionRegistry;
    }

    public void setUserDestinationPrefix(String prefix) {
        Assert.hasText((String)prefix, (String)"prefix must not be empty");
        this.destinationPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
    }

    public String getDestinationPrefix() {
        return this.destinationPrefix;
    }

    public UserSessionRegistry getUserSessionRegistry() {
        return this.userSessionRegistry;
    }

    @Override
    public UserDestinationResult resolveDestination(Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        DestinationInfo info = this.parseUserDestination(headers);
        if (info == null) {
            return null;
        }
        HashSet<String> targetDestinations = new HashSet<String>();
        for (String sessionId : info.getSessionIds()) {
            targetDestinations.add(this.getTargetDestination(headers.getDestination(), info.getDestinationWithoutPrefix(), sessionId, info.getUser()));
        }
        return new UserDestinationResult(headers.getDestination(), targetDestinations, info.getSubscribeDestination(), info.getUser());
    }

    private DestinationInfo parseUserDestination(SimpMessageHeaderAccessor headers) {
        Set<String> sessionIds;
        String user;
        String subscribeDestination;
        String destinationWithoutPrefix;
        String destination = headers.getDestination();
        Principal principal = headers.getUser();
        SimpMessageType messageType = headers.getMessageType();
        if (SimpMessageType.SUBSCRIBE.equals((Object)messageType) || SimpMessageType.UNSUBSCRIBE.equals((Object)messageType)) {
            if (!this.checkDestination(destination, this.destinationPrefix)) {
                return null;
            }
            if (principal == null) {
                logger.error((Object)"Ignoring message, no principal info available");
                return null;
            }
            if (headers.getSessionId() == null) {
                logger.error((Object)"Ignoring message, no session id available");
                return null;
            }
            destinationWithoutPrefix = destination.substring(this.destinationPrefix.length() - 1);
            subscribeDestination = destination;
            user = principal.getName();
            sessionIds = Collections.singleton(headers.getSessionId());
        } else if (SimpMessageType.MESSAGE.equals((Object)messageType)) {
            if (!this.checkDestination(destination, this.destinationPrefix)) {
                return null;
            }
            int startIndex = this.destinationPrefix.length();
            int endIndex = destination.indexOf(47, startIndex);
            Assert.isTrue((endIndex > 0 ? 1 : 0) != 0, (String)"Expected destination pattern \"/principal/{userId}/**\"");
            destinationWithoutPrefix = destination.substring(endIndex);
            subscribeDestination = this.destinationPrefix.substring(0, startIndex - 1) + destinationWithoutPrefix;
            user = destination.substring(startIndex, endIndex);
            user = StringUtils.replace((String)user, (String)"%2F", (String)"/");
            sessionIds = this.userSessionRegistry.getSessionIds(user);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring " + (Object)((Object)messageType) + " message"));
            }
            return null;
        }
        return new DestinationInfo(destinationWithoutPrefix, subscribeDestination, user, sessionIds);
    }

    protected boolean checkDestination(String destination, String requiredPrefix) {
        if (destination == null) {
            logger.trace((Object)"Ignoring message, no destination");
            return false;
        }
        if (!destination.startsWith(requiredPrefix)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring message to " + destination + ", not a \"user\" destination"));
            }
            return false;
        }
        return true;
    }

    protected String getTargetDestination(String sourceDestination, String sourceDestinationWithoutPrefix, String sessionId, String user) {
        return sourceDestinationWithoutPrefix + "-user" + sessionId;
    }

    private static class DestinationInfo {
        private final String destinationWithoutPrefix;
        private final String subscribeDestination;
        private final String user;
        private final Set<String> sessionIds;

        public DestinationInfo(String destinationWithoutPrefix, String subscribeDestination, String user, Set<String> sessionIds) {
            this.user = user;
            this.destinationWithoutPrefix = destinationWithoutPrefix;
            this.subscribeDestination = subscribeDestination;
            this.sessionIds = sessionIds;
        }

        public String getDestinationWithoutPrefix() {
            return this.destinationWithoutPrefix;
        }

        public String getSubscribeDestination() {
            return this.subscribeDestination;
        }

        public String getUser() {
            return this.user;
        }

        public Set<String> getSessionIds() {
            return this.sessionIds;
        }
    }
}

