/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.converter.MessageConversionException;
import org.springframework.messaging.support.converter.MessageConverter;
import org.springframework.util.Assert;

public class MappingJackson2MessageConverter
implements MessageConverter<Object> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private Type defaultObjectType = Map.class;
    private Class<?> defaultMessagePayloadClass = byte[].class;

    public void setDefaultObjectClass(Type defaultObjectType) {
        Assert.notNull((Object)defaultObjectType, (String)"defaultObjectType is required");
        this.defaultObjectType = defaultObjectType;
    }

    public void setDefaultTargetPayloadClass(Class<?> payloadClass) {
        Assert.isTrue((byte[].class.equals(payloadClass) || String.class.equals(payloadClass) ? 1 : 0) != 0, (String)("Payload class must be byte[] or String: " + payloadClass));
        this.defaultMessagePayloadClass = payloadClass;
    }

    @Override
    public Object fromMessage(Message<?> message, Type objectType) {
        JavaType javaType = objectType != null ? this.objectMapper.constructType(objectType) : this.objectMapper.constructType(this.defaultObjectType);
        Object payload = message.getPayload();
        try {
            if (payload instanceof byte[]) {
                return this.objectMapper.readValue((byte[])payload, javaType);
            }
            if (payload instanceof String) {
                return this.objectMapper.readValue((String)payload, javaType);
            }
            throw new IllegalArgumentException("Unexpected message payload type: " + payload);
        }
        catch (IOException ex) {
            throw new MessageConversionException(message, "Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    @Override
    public <P> Message<P> toMessage(Object object) {
        Object payload;
        block4: {
            try {
                if (byte[].class.equals(this.defaultMessagePayloadClass)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    this.objectMapper.writeValue((OutputStream)out, object);
                    payload = out.toByteArray();
                    break block4;
                }
                if (String.class.equals(this.defaultMessagePayloadClass)) {
                    StringWriter writer = new StringWriter();
                    this.objectMapper.writeValue((Writer)writer, object);
                    payload = ((Object)writer).toString();
                    break block4;
                }
                throw new IllegalStateException("Unexpected payload class: " + this.defaultMessagePayloadClass);
            }
            catch (IOException ex) {
                throw new MessageConversionException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return MessageBuilder.withPayload(payload).build();
    }
}

