/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support.channel;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.channel.AbstractSubscribableChannel;

public class ExecutorSubscribableChannel
extends AbstractSubscribableChannel {
    private final Executor executor;
    private final Set<MessageHandler> handlers = new CopyOnWriteArraySet<MessageHandler>();

    public ExecutorSubscribableChannel() {
        this(null);
    }

    public ExecutorSubscribableChannel(Executor executor) {
        this.executor = executor;
    }

    @Override
    protected boolean hasSubscription(MessageHandler handler) {
        return this.handlers.contains(handler);
    }

    @Override
    public boolean sendInternal(final Message<?> message, long timeout) {
        for (final MessageHandler handler : this.handlers) {
            if (this.executor == null) {
                handler.handleMessage(message);
                continue;
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    handler.handleMessage(message);
                }
            });
        }
        return true;
    }

    @Override
    public boolean subscribeInternal(MessageHandler handler) {
        return this.handlers.add(handler);
    }

    @Override
    public boolean unsubscribeInternal(MessageHandler handler) {
        return this.handlers.remove(handler);
    }
}

