/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support.channel;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.channel.ChannelInterceptor;

class ChannelInterceptorChain {
    private static final Log logger = LogFactory.getLog(ChannelInterceptorChain.class);
    private final List<ChannelInterceptor> interceptors = new CopyOnWriteArrayList<ChannelInterceptor>();

    ChannelInterceptorChain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(List<ChannelInterceptor> interceptors) {
        List<ChannelInterceptor> list = this.interceptors;
        synchronized (list) {
            this.interceptors.clear();
            return this.interceptors.addAll(interceptors);
        }
    }

    public boolean add(ChannelInterceptor interceptor) {
        return this.interceptors.add(interceptor);
    }

    public List<ChannelInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("preSend on channel '" + channel + "', message: " + message));
        }
        for (ChannelInterceptor interceptor : this.interceptors) {
            message = interceptor.preSend(message, channel);
            if (message != null) continue;
            return null;
        }
        return message;
    }

    public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("postSend (sent=" + sent + ") on channel '" + channel + "', message: " + message));
        }
        for (ChannelInterceptor interceptor : this.interceptors) {
            interceptor.postSend(message, channel, sent);
        }
    }

    public boolean preReceive(MessageChannel channel) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("preReceive on channel '" + channel + "'"));
        }
        for (ChannelInterceptor interceptor : this.interceptors) {
            if (interceptor.preReceive(channel)) continue;
            return false;
        }
        return true;
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        if (message != null && logger.isTraceEnabled()) {
            logger.trace((Object)("postReceive on channel '" + channel + "', message: " + message));
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)("postReceive on channel '" + channel + "', message is null"));
        }
        for (ChannelInterceptor interceptor : this.interceptors) {
            message = interceptor.postReceive(message, channel);
            if (message != null) continue;
            return null;
        }
        return message;
    }
}

