/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GenericMessage<T>
implements Message<T>,
Serializable {
    private static final long serialVersionUID = -9004496725833093406L;
    private final T payload;
    private final MessageHeaders headers;

    protected GenericMessage(T payload) {
        this(payload, null);
    }

    protected GenericMessage(T payload, Map<String, Object> headers) {
        Assert.notNull(payload, (String)"payload must not be null");
        headers = headers == null ? new HashMap<String, Object>() : new HashMap<String, Object>(headers);
        this.headers = new MessageHeaders(headers);
        this.payload = payload;
    }

    @Override
    public MessageHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public T getPayload() {
        return this.payload;
    }

    public String toString() {
        return "[Payload=" + this.payload + "][Headers=" + this.headers + "]";
    }

    public int hashCode() {
        return this.headers.hashCode() * 23 + ObjectUtils.nullSafeHashCode(this.payload);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof GenericMessage) {
            GenericMessage other = (GenericMessage)obj;
            if (!this.headers.getId().equals(other.headers.getId())) {
                return false;
            }
            return this.headers.equals(other.headers) && this.payload.equals(other.payload);
        }
        return false;
    }
}

