/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.handler.websocket.SubProtocolHandler;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.handler.MutableUserQueueSuffixResolver;
import org.springframework.messaging.simp.handler.SimpleUserQueueSuffixResolver;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.simp.stomp.StompMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class StompProtocolHandler
implements SubProtocolHandler {
    public static final String CONNECTED_USER_HEADER = "user-name";
    public static final String QUEUE_SUFFIX_HEADER = "queue-suffix";
    private final Log logger = LogFactory.getLog(StompProtocolHandler.class);
    private final StompMessageConverter stompMessageConverter = new StompMessageConverter();
    private MutableUserQueueSuffixResolver queueSuffixResolver = new SimpleUserQueueSuffixResolver();

    public void setUserQueueSuffixResolver(MutableUserQueueSuffixResolver resolver) {
        this.queueSuffixResolver = resolver;
    }

    public MutableUserQueueSuffixResolver getUserQueueSuffixResolver() {
        return this.queueSuffixResolver;
    }

    @Override
    public List<String> getSupportedProtocols() {
        return Arrays.asList("v10.stomp", "v11.stomp", "v12.stomp");
    }

    @Override
    public void handleMessageFromClient(WebSocketSession session, WebSocketMessage webSocketMessage, MessageChannel outputChannel) {
        try {
            Assert.isInstanceOf(TextMessage.class, (Object)webSocketMessage);
            String payload = (String)((TextMessage)webSocketMessage).getPayload();
            Message<?> message = this.stompMessageConverter.toMessage(payload);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Processing STOMP message: " + message));
            }
            try {
                StompHeaderAccessor headers = StompHeaderAccessor.wrap(message);
                headers.setSessionId(session.getId());
                headers.setUser(session.getPrincipal());
                message = MessageBuilder.withPayloadAndHeaders(message.getPayload(), headers).build();
                if (SimpMessageType.CONNECT.equals((Object)headers.getMessageType())) {
                    this.handleConnect(session, message);
                }
                outputChannel.send(message);
            }
            catch (Throwable t) {
                this.logger.error((Object)"Terminating STOMP session due to failure to send message: ", t);
                this.sendErrorMessage(session, t);
            }
        }
        catch (Throwable error) {
            this.sendErrorMessage(session, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessageToClient(WebSocketSession session, Message<?> message) {
        StompHeaderAccessor headers = StompHeaderAccessor.wrap(message);
        headers.setCommandIfNotSet(StompCommand.MESSAGE);
        if (StompCommand.CONNECTED.equals((Object)headers.getCommand())) {
            return;
        }
        if (StompCommand.MESSAGE.equals((Object)headers.getCommand()) && headers.getSubscriptionId() == null) {
            this.logger.error((Object)("Ignoring message, no subscriptionId header: " + message));
            return;
        }
        if (!(message.getPayload() instanceof byte[])) {
            this.logger.error((Object)("Ignoring message, expected byte[] content: " + message));
            return;
        }
        try {
            message = MessageBuilder.withPayloadAndHeaders(message.getPayload(), headers).build();
            byte[] bytes = this.stompMessageConverter.fromMessage(message);
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)new String(bytes, Charset.forName("UTF-8"))));
        }
        catch (Throwable t) {
            this.sendErrorMessage(session, t);
        }
        finally {
            if (StompCommand.ERROR.equals((Object)headers.getCommand())) {
                try {
                    session.close(CloseStatus.PROTOCOL_ERROR);
                }
                catch (IOException e) {}
            }
        }
    }

    protected void handleConnect(WebSocketSession session, Message<?> message) throws IOException {
        StompHeaderAccessor connectHeaders = StompHeaderAccessor.wrap(message);
        StompHeaderAccessor connectedHeaders = StompHeaderAccessor.create(StompCommand.CONNECTED);
        Set<String> acceptVersions = connectHeaders.getAcceptVersion();
        if (acceptVersions.contains("1.2")) {
            connectedHeaders.setVersion("1.2");
        } else if (acceptVersions.contains("1.1")) {
            connectedHeaders.setVersion("1.1");
        } else if (!acceptVersions.isEmpty()) {
            throw new StompConversionException("Unsupported version '" + acceptVersions + "'");
        }
        connectedHeaders.setHeartbeat(0L, 0L);
        Principal principal = session.getPrincipal();
        if (principal != null) {
            connectedHeaders.setNativeHeader(CONNECTED_USER_HEADER, principal.getName());
            connectedHeaders.setNativeHeader(QUEUE_SUFFIX_HEADER, session.getId());
            if (this.queueSuffixResolver != null) {
                String suffix = session.getId();
                this.queueSuffixResolver.addQueueSuffix(principal.getName(), session.getId(), suffix);
            }
        }
        Message<byte[]> connectedMessage = MessageBuilder.withPayloadAndHeaders(new byte[0], connectedHeaders).build();
        byte[] bytes = this.stompMessageConverter.fromMessage(connectedMessage);
        session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)new String(bytes, Charset.forName("UTF-8"))));
    }

    protected void sendErrorMessage(WebSocketSession session, Throwable error) {
        StompHeaderAccessor headers = StompHeaderAccessor.create(StompCommand.ERROR);
        headers.setMessage(error.getMessage());
        Message<byte[]> message = MessageBuilder.withPayloadAndHeaders(new byte[0], headers).build();
        byte[] bytes = this.stompMessageConverter.fromMessage(message);
        try {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)new String(bytes, Charset.forName("UTF-8"))));
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    @Override
    public String resolveSessionId(Message<?> message) {
        StompHeaderAccessor headers = StompHeaderAccessor.wrap(message);
        return headers.getSessionId();
    }

    @Override
    public void afterSessionStarted(WebSocketSession session, MessageChannel outputChannel) {
    }

    @Override
    public void afterSessionEnded(WebSocketSession session, CloseStatus closeStatus, MessageChannel outputChannel) {
        if (this.queueSuffixResolver != null && session.getPrincipal() != null) {
            this.queueSuffixResolver.removeQueueSuffix(session.getPrincipal().getName(), session.getId());
        }
        StompHeaderAccessor headers = StompHeaderAccessor.create(StompCommand.DISCONNECT);
        headers.setSessionId(session.getId());
        Message<byte[]> message = MessageBuilder.withPayloadAndHeaders(new byte[0], headers).build();
        outputChannel.send(message);
    }
}

