/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;

public class StompMessageConverter {
    private static final Charset STOMP_CHARSET = Charset.forName("UTF-8");
    public static final byte LF = 10;
    public static final byte CR = 13;
    private static final byte COLON = 58;

    public Message<?> toMessage(Object stompContent) {
        int payloadIndex;
        byte[] byteContent = null;
        if (stompContent instanceof String) {
            byteContent = ((String)stompContent).getBytes(STOMP_CHARSET);
        } else if (stompContent instanceof byte[]) {
            byteContent = (byte[])stompContent;
        } else {
            throw new IllegalArgumentException("stompContent is neither String nor byte[]: " + stompContent.getClass());
        }
        int totalLength = byteContent.length;
        if (byteContent[totalLength - 1] == 0) {
            --totalLength;
        }
        if ((payloadIndex = this.findIndexOfPayload(byteContent)) == 0) {
            throw new StompConversionException("No command found");
        }
        String headerContent = new String(byteContent, 0, payloadIndex, STOMP_CHARSET);
        Parser parser = new Parser(headerContent);
        StompCommand command = StompCommand.valueOf(parser.nextToken((byte)10).trim());
        Assert.notNull((Object)((Object)command), (String)"No command found");
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        while (parser.hasNext()) {
            String header = parser.nextToken((byte)58);
            if (header == null) continue;
            if (parser.hasNext()) {
                String value = parser.nextToken((byte)10);
                headers.add((Object)header, (Object)value);
                continue;
            }
            throw new StompConversionException("Parse exception for " + headerContent);
        }
        byte[] payload = new byte[totalLength - payloadIndex];
        System.arraycopy(byteContent, payloadIndex, payload, 0, totalLength - payloadIndex);
        StompHeaderAccessor stompHeaders = StompHeaderAccessor.create(command, (Map<String, List<String>>)headers);
        return MessageBuilder.withPayloadAndHeaders(payload, stompHeaders).build();
    }

    private int findIndexOfPayload(byte[] bytes) {
        int i;
        for (i = 0; i < bytes.length && (bytes[i] == 10 || bytes[i] == 13); ++i) {
            bytes[i] = 32;
        }
        int index = 0;
        while (i < bytes.length - 1) {
            if (bytes[i] == 10 && bytes[i + 1] == 10) {
                index = i + 2;
                break;
            }
            if (i < bytes.length - 3 && bytes[i] == 13 && bytes[i + 1] == 10 && bytes[i + 2] == 13 && bytes[i + 3] == 10) {
                index = i + 4;
                break;
            }
            ++i;
        }
        if (i >= bytes.length) {
            throw new StompConversionException("No end of headers found");
        }
        return index;
    }

    public byte[] fromMessage(Message<?> message) {
        if (!(message.getPayload() instanceof byte[])) {
            throw new IllegalArgumentException("stompContent is not byte[]: " + message.getPayload().getClass());
        }
        byte[] payload = (byte[])message.getPayload();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StompHeaderAccessor stompHeaders = StompHeaderAccessor.wrap(message);
        try {
            out.write(stompHeaders.getCommand().toString().getBytes("UTF-8"));
            out.write(10);
            for (Map.Entry<String, List<String>> entry : stompHeaders.toStompHeaderMap().entrySet()) {
                String key = entry.getKey();
                key = this.replaceAllOutbound(key);
                for (String value : entry.getValue()) {
                    out.write(key.getBytes("UTF-8"));
                    out.write(58);
                    value = this.replaceAllOutbound(value);
                    out.write(value.getBytes("UTF-8"));
                    out.write(10);
                }
            }
            out.write(10);
            out.write(payload);
            out.write(0);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new StompConversionException("Failed to serialize " + message, e);
        }
    }

    private String replaceAllOutbound(String key) {
        return key.replaceAll("\\\\", "\\\\").replaceAll(":", "\\\\c").replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
    }

    private class Parser {
        private final String content;
        private int offset;

        public Parser(String content) {
            this.content = content;
        }

        public boolean hasNext() {
            return this.offset < this.content.length();
        }

        public String nextToken(byte delimiter) {
            if (this.offset >= this.content.length()) {
                return null;
            }
            int delimAt = this.content.indexOf(delimiter, this.offset);
            if (delimAt == -1) {
                if (this.offset == this.content.length() - 1 && delimiter == 58 && this.content.charAt(this.offset) == '\n') {
                    ++this.offset;
                    return null;
                }
                if (this.offset == this.content.length() - 2 && delimiter == 58 && this.content.charAt(this.offset) == '\r' && this.content.charAt(this.offset + 1) == '\n') {
                    this.offset += 2;
                    return null;
                }
                throw new StompConversionException("No delimiter found at offset " + this.offset + " in " + this.content);
            }
            int escapeAt = this.content.indexOf(92, this.offset);
            String token = this.content.substring(this.offset, delimAt + 1);
            this.offset += token.length();
            if (escapeAt >= 0 && escapeAt < delimAt) {
                char escaped = this.content.charAt(escapeAt + 1);
                if (escaped == 'n' || escaped == 'c' || escaped == '\\') {
                    token = token.replaceAll("\\\\n", "\n").replaceAll("\\\\r", "\r").replaceAll("\\\\c", ":").replaceAll("\\\\\\\\", "\\\\");
                } else {
                    throw new StompConversionException("Invalid escape sequence \\" + escaped);
                }
            }
            int length = token.length();
            if (delimiter == 10 && length > 1 && token.charAt(length - 2) == '\r') {
                return token.substring(0, length - 2);
            }
            return token.substring(0, length - 1);
        }
    }
}

