/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.messaging.simp.SimpMessageType;

public enum StompCommand {
    CONNECT,
    STOMP,
    SEND,
    SUBSCRIBE,
    UNSUBSCRIBE,
    ACK,
    NACK,
    BEGIN,
    COMMIT,
    ABORT,
    DISCONNECT,
    CONNECTED,
    MESSAGE,
    RECEIPT,
    ERROR;

    private static Map<StompCommand, SimpMessageType> messageTypeLookup;
    private static Set<StompCommand> destinationRequiredLookup;
    private static Set<StompCommand> subscriptionIdRequiredLookup;

    public SimpMessageType getMessageType() {
        SimpMessageType type = messageTypeLookup.get((Object)this);
        return type != null ? type : SimpMessageType.OTHER;
    }

    public boolean requiresDestination() {
        return destinationRequiredLookup.contains((Object)this);
    }

    public boolean requiresSubscriptionId() {
        return subscriptionIdRequiredLookup.contains((Object)this);
    }

    static {
        messageTypeLookup = new HashMap<StompCommand, SimpMessageType>();
        destinationRequiredLookup = new HashSet<StompCommand>(Arrays.asList(SEND, SUBSCRIBE, MESSAGE));
        subscriptionIdRequiredLookup = new HashSet<StompCommand>(Arrays.asList(SUBSCRIBE, UNSUBSCRIBE, MESSAGE));
        messageTypeLookup.put(CONNECT, SimpMessageType.CONNECT);
        messageTypeLookup.put(STOMP, SimpMessageType.CONNECT);
        messageTypeLookup.put(SEND, SimpMessageType.MESSAGE);
        messageTypeLookup.put(MESSAGE, SimpMessageType.MESSAGE);
        messageTypeLookup.put(SUBSCRIBE, SimpMessageType.SUBSCRIBE);
        messageTypeLookup.put(UNSUBSCRIBE, SimpMessageType.UNSUBSCRIBE);
        messageTypeLookup.put(DISCONNECT, SimpMessageType.DISCONNECT);
    }
}

