/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.MessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.handler.SimpleUserQueueSuffixResolver;
import org.springframework.messaging.simp.handler.UserQueueSuffixResolver;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class UserDestinationMessageHandler
implements MessageHandler {
    private static final Log logger = LogFactory.getLog(UserDestinationMessageHandler.class);
    private final MessageSendingOperations<String> messagingTemplate;
    private String destinationPrefix = "/user/";
    private UserQueueSuffixResolver userQueueSuffixResolver = new SimpleUserQueueSuffixResolver();

    public UserDestinationMessageHandler(MessageSendingOperations<String> messagingTemplate, UserQueueSuffixResolver userQueueSuffixResolver) {
        Assert.notNull(messagingTemplate, (String)"messagingTemplate is required");
        Assert.notNull((Object)userQueueSuffixResolver, (String)"userQueueSuffixResolver is required");
        this.messagingTemplate = messagingTemplate;
        this.userQueueSuffixResolver = userQueueSuffixResolver;
    }

    public void setDestinationPrefix(String prefix) {
        Assert.hasText((String)prefix, (String)"prefix is required");
        this.destinationPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
    }

    public String getDestinationPrefix() {
        return this.destinationPrefix;
    }

    public UserQueueSuffixResolver getUserQueueSuffixResolver() {
        return this.userQueueSuffixResolver;
    }

    public MessageSendingOperations<String> getMessagingTemplate() {
        return this.messagingTemplate;
    }

    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        UserDestinationParser destinationParser;
        String user;
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        SimpMessageType messageType = headers.getMessageType();
        String destination = headers.getDestination();
        if (!SimpMessageType.MESSAGE.equals((Object)messageType)) {
            return;
        }
        if (!this.checkDestination(destination)) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Processing message to destination " + destination));
        }
        if ((user = (destinationParser = new UserDestinationParser(destination)).getUser()) == null) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Ignoring message, expected destination pattern \"" + this.destinationPrefix + "{userId}/**\": " + destination));
            }
            return;
        }
        for (String sessionId : this.userQueueSuffixResolver.getUserQueueSuffixes(user)) {
            String targetDestination = destinationParser.getTargetDestination(sessionId);
            headers.setDestination(targetDestination);
            message = MessageBuilder.withPayloadAndHeaders(message.getPayload(), headers).build();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Sending message to resolved target destination " + targetDestination));
            }
            this.messagingTemplate.send(targetDestination, message);
        }
    }

    private boolean checkDestination(String destination) {
        return destination != null && destination.startsWith(this.destinationPrefix);
    }

    private class UserDestinationParser {
        private final String user;
        private final String targetDestination;

        public UserDestinationParser(String destination) {
            int userStartIndex = UserDestinationMessageHandler.this.destinationPrefix.length();
            int userEndIndex = destination.indexOf(47, userStartIndex);
            if (userEndIndex > 0) {
                this.user = destination.substring(userStartIndex, userEndIndex);
                this.targetDestination = destination.substring(userEndIndex);
            } else {
                this.user = null;
                this.targetDestination = null;
            }
        }

        public String getUser() {
            return this.user;
        }

        public String getTargetDestination(String sessionId) {
            return this.targetDestination != null ? this.targetDestination + sessionId : null;
        }
    }
}

